<?php

namespace Shop\Models\Category;

use Shop\Domain\ProductCategory\Contracts\ProductCategoryEntityInterface;
use Shop\Models\Category\Base\Category as BaseCategory;

/**
 * Skeleton subclass for representing a row from the 'shop_categories' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Category extends BaseCategory implements ProductCategoryEntityInterface
{

    /**
     * @var int
     */
    protected $countChildrens = 0;

    /**
     * @var int
     */
    protected $countProducts = 0;

    /**
     * @param int $count
     * @return Category
     */
    public function setCountChildrens(int $count): self
    {
        $this->countChildrens = $count;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountChildrens(): int
    {
        return $this->countChildrens;
    }


    /**
     * @param int $count
     * @return Category
     */
    public function setCountProducts(int $count): self
    {
        $this->countProducts = $count;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountProducts(): int
    {
        return $this->countProducts;
    }

    /**
     * @deprecated
     * @param string $name
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getNameWithParent($name = " одежда, "): string
    {
        return ltrim(

            sprintf("%s%s%s", $this->getParentCategory() ? $this->getParentCategory()->getTitle() : null, $name, $this->getTitle())
            ,
            " -"
        );
    }

    /**
     *
     * @param type $name
     * @return type
     */
    public function getNameWithParentName($name = " / ")
    {
        return ltrim(

            sprintf("%s%s%s", $this->getParentCategory() ? $this->getParentCategory()->getTitle() : null, $name, $this->getTitle())
            ,
            $name
        );
    }
}
