<?php

namespace Shop\Domain\Sale;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Sale\Contracts\SaleEntityInterface;

/**
* Description of Sale
*
* @author Diamond Code Generator
*/
class SaleCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return SaleEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }
}               