<?php

namespace Shop\Application\Basket\Dto;

/**
 * DTO для информации о скидке
 *
 * @author Admin
 */
class Discount
{
    /**
     * @var float
     */
    protected $percent = 0.00;

    /**
     * @var float
     */
    protected $sum = 0.00;

    /**
     * @return float
     */
    public function getPercent(): float
    {
        return $this->percent;
    }

    /**
     * @param float $percent
     * @return Discount
     */
    public function setPercent(float $percent): Discount
    {
        $this->percent = $percent;
        return $this;
    }

    /**
     * @return float
     */
    public function getSum(): float
    {
        return $this->sum;
    }

    /**
     * @param float $sum
     * @return Discount
     */
    public function setSum(float $sum): Discount
    {
        $this->sum = $sum;
        return $this;
    }

}