<?php


namespace Shop\Application\Shopping\PrepareProviderOrderDataForReport;


class PrepareProviderOrderDataForReportCommand
{
    protected $order;
    protected $result;

    /**
     * PrepareProviderOrderDataForReportCommand constructor.
     * @param ProviderOrderEntityInterface $order
     * @param Result $result
     */
    public function __construct(ProviderOrderEntityInterface $order, Result $result)
    {
        $this->result = $result;
        $this->order = $order;
    }

    /**
     * @return ProviderOrderEntityInterface
     */
    public function getOrder(): ProviderOrderEntityInterface
    {
        return $this->order;
    }


    /**
     * @return Result
     */
    public function getResult(): Result
    {
        return $this->result;
    }

}