<?php


namespace Shop\Repositories\PricePosition;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\PricePosition\Contracts\PricePositionCriteriaInterface;

class PricePositionCriteria extends AbstractCriteria implements PricePositionCriteriaInterface
{
    /**
     * @var int|null
     */
    protected $filterByPricelistSheetId;

    /**
     * @var string|null
     */
    protected $filterByRefId;

    /**
     * @var string|null
     */
    protected $searchByProductName;

    /**
     * @var int|null
     */
    protected $filterByProductId;

    /**
     * @return int|null
     */
    public function getFilterByProductId(): ?int
    {
        return $this->filterByProductId;
    }

    /**
     * @param int|null $filterByProductId
     * @return PricePositionCriteria
     */
    public function setFilterByProductId(?int $filterByProductId): PricePositionCriteria
    {
        $this->filterByProductId = $filterByProductId;
        return $this;
    }




    /**
     * @return string|null
     */
    public function getFilterByRefId(): ?string
    {
        return $this->filterByRefId;
    }

    /**
     * @param string|null $filterByRefId
     * @return PricePositionCriteria
     */
    public function setFilterByRefId(?string $filterByRefId): PricePositionCriteria
    {
        $this->filterByRefId = $filterByRefId;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSearchByProductName(): ?string
    {
        return $this->searchByProductName;
    }

    /**
     * @param string|null $searchByProductName
     * @return PricePositionCriteria
     */
    public function setSearchByProductName(?string $searchByProductName)
    {
        $this->searchByProductName = $searchByProductName;
        return $this;
    }



    /**
     * @return int|null
     */
    public function getFilterByPricelistSheetId(): ?int
    {
        return $this->filterByPricelistSheetId;
    }

    /**
     * @param int|null $filterByPricelistSheetId
     * @return PricePositionCriteria
     */
    public function setFilterByPricelistSheetId(?int $filterByPricelistSheetId): PricePositionCriteria
    {
        $this->filterByPricelistSheetId = $filterByPricelistSheetId;
        return $this;
    }






    public static function create()
    {
        return new self;
    }

}