<?php

namespace Shop\Repositories\Payment;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use QueryBuilder\SearchCriteria;
use Repo\CollectionInterface;
use Repo\Concrete\AbstractCrudRepository;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Payment\Contracts\PaymentEntityInterface;
use Shop\Domain\Payment\PaymentCollection;
use Shop\Models\Payment\Payment;
use Shop\Models\Payment\PaymentQuery;

/**
 * Class PaymentRepository
 * @package Shop\Repositories\Payment
 */
class PaymentRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @param PaginationInterface|PaymentCriteriaInterface $criteria
     * @param SearchCriteria|PaymentQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $this->modifyCriteriaForFilterSort($criteria,$dbCriteria);
    }

    /**
     * @return EntityInterface|PaymentEntityInterface
     */
    public static function createEntity(): \Repo\EntityInterface
    {
        return new Payment();
    }

    protected function createQuery(): ModelCriteria
    {
        return PaymentQuery::create();
    }

    /**
     * @param PaginationInterface|PaymentCriteriaInterface $criteria
     * @return CollectionInterface
     */
    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new PaymentCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }

}