<?php

namespace Shop\Domain\Country;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Country\Contracts\CountryEntityInterface;

/**
 * Description of Country
 *
 * @author Diamond Code Generator
 */
class CountryCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return CountryEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }


}               