<?php

namespace Shop\Modules\MetricWidget;

use Shop\UseCases\Catalog\CatalogService;
use Shop\UseCases\Notification\NotificationService;
use Shop\Application\Office\OfficeService;
use Shop\UseCases\Shopping\ShoppingService;

/**
 * Description of MetricWidget
 *
 * @author Diamond Code Generator
 */
class MetricWidget extends \Core\ModuleController
{

    protected $customerRepo;
    protected $orderRepo;
    protected $productRepo;
    protected $confMain;
    //protected $smsService;
    //protected $shopService;
    protected $officeService;
    protected $shoppingService;
    protected $catalogService;
    protected $notificationService;

    public function __construct(

        NotificationService $notificationService,
        \Shop\Config\Main $confMain,
        OfficeService $officeService,
        ShoppingService $shoppingService,
        CatalogService $catalogService
//        \Shop\Services\Sms $smsService,
//        \Shop\Services\Shop $shopService
    )
    {

        $this->confMain = $confMain;

        $this->officeService = $officeService;
        $this->shoppingService = $shoppingService;
        $this->catalogService = $catalogService;
        $this->notificationService = $notificationService;
    }

    public function process(): string
    {

        $clientsCount = $this->officeService->getCustomersCount();

        $clientsCountActive = $this->officeService->getActiveCustomersCount();

        $ordersCount = $this->shoppingService->getCustomerOrdersCount();

        $productsCount = $this->catalogService->getProductsCount();

        $ordersSumm = $this->shoppingService->getSumCustomerOrdersByIgnoreStates((array)$this->confMain->getStateCancel());


        return $this->render([
            "clientsCount" => (int)$clientsCount,
            "clientsCountActive" => (int)$clientsCountActive,
            "percent" => $clientsCount ? round($clientsCountActive / $clientsCount, 2) * 100 : 0,
            "ordersCount" => $ordersCount,
            "productsCount" => $productsCount,
            "ordersSumm" => \Shop\Helpers\Price::format($ordersSumm, 0),
            "cur" => $this->confMain->getCurencyDisplay(),
            "smsInfo" => $this->notificationService->getSmsBalance()
        ]);
    }

}