<?php

namespace Shop\Modules\AdminBaskets;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Diamond\Helpers\Form;
use DiamondTable\CommandFactory;
use DiamondTable\Commands\TableRowSave;
use DiamondTable\Commands\TableRowSuccessTest;
use DiamondTable\TableFactory;
use Shop\Repositories\OrderItem\OrderItemCriteria;
use Shop\Repositories\OrderItem\OrderItemRepository;

/**
 * Description of AdminBaskets
 *
 * @author Diamond Code Generator
 */
class AdminBaskets extends ModuleController
{

    protected $tableFactory;
    protected $controlBuilder;
    protected $orderPositionRepo;

    public function __construct(TableFactory $tableFactory, OrderItemRepository $orderItemRepository,
                                ControlBuilder $controlBuilder)
    {
        $this->tableFactory = $tableFactory;
        $this->orderPositionRepo = $orderItemRepository;
        $this->controlBuilder = $controlBuilder;
    }


    /**
     * @return string
     * @throws \ActiveTable\Exceptions\ActiveTableException
     * @throws \ReflectionException
     */
    public function process(): string
    {

        //return Form::buildAnnouncementMessage('Раздел в разработке');

        $table = $this->tableFactory->buildAdminTable($this->orderPositionRepo, OrderItemCriteria::create());

        $table
            ->addRowActionCommand('merge-orders',new TableRowSuccessTest($table),'Слияние заказов');



        $table
            ->addColumn(
                new ColumnTable('id', '№')
            )
            ->addColumn(
                new ColumnTable('article', 'Артикул')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
            );

//        $validations = ['email','other' => function(string $value){
//            return sprintf('значение `%s` должно быть уникальным', $value);
//        }];

        $table
            ->addField(
                $this->controlBuilder->buildInput('article'), true
            );

        return $table->render();
    }
}               