<?php


namespace Shop\Repositories\Score;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Score\ScoreCollection;
use Shop\Models\Score\Score;
use Shop\Models\Score\ScoreQuery;

class ScoreRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new Score();
    }

    protected function createQuery(): ModelCriteria
    {
        return ScoreQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        // TODO: Implement modifyCriteria() method.
    }

    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new ScoreCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }

    /**
     * @param int $csutomerId
     * @return float
     */
    public function getSumByCustomerId(int $csutomerId): float
    {
        $scores = $this->createQuery()
            ->addAsColumn('summ', 'SUM(score)')
            ->filterBycustomerId($csutomerId)
            ->findOne();
        return (float) $scores->getVirtualColumn("summ");
    }

}