<?php
namespace Shop\Application\Shopping\SendNotifyAboutPostCode;

use Diamond\Application\Notification\NotificationService;
use Shop\Application\Shopping\ShoppingService;
use Shop\Config\Main;

class SendNotifyAboutPostCodeHandler
{
    protected $confMain;
    protected $notificationService;
    protected $shoppingService;

    /**
     * SendNotifyAboutPostCodeHandler constructor.
     * @param Main $confMain
     * @param NotificationService $notificationService
     * @param ShoppingService $shoppingService
     */
    public function __construct(Main $confMain, NotificationService $notificationService, ShoppingService $shoppingService)
    {
        $this->confMain = $confMain;
        $this->notificationService = $notificationService;
        $this->shoppingService = $shoppingService;
    }

    /**
     * @param SendNotifyAboutPostCodeCommand $command
     * @throws \Propel\Runtime\Exception\PropelException
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function handle(SendNotifyAboutPostCodeCommand $command): void
    {
        $order = $command->getOrder();


        $customer = $order->getCustomer();

        if ($customer->getNotifyOrder() === 'N') {
            return;
        }

        $data = $this->shoppingService->prepareCustomerOrderDataForReport($order);

        //на email
        if ($customer->isNotifyEmail() === true && $customer->getEmail()) {
            $this->notificationService->sendToEmailByReport('change_post_code_order_email', $customer->getEmail(), $data);
        }

        //на cmc
        if ($customer->isNotifySms() === true && $customer->getPhone()) {
            $this->notificationService->sendToPhoneByReport('change_post_code_order_sms', $customer->getPhone(), $data);
        }
    }

}