<?php

namespace Shop\Modules\AdminSettingsMain;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Diamond\Helpers\Form;
use Shop\Config\Main;
use Shop\Repositories\Currency\CurrencyCriteria;
use Shop\Repositories\Currency\CurrencyRepository;

/**
 * Description of AdminConfigMain
 *
 * @author Diamond Code Generator
 */
class AdminSettingsMain extends \Core\ModuleController
{

    protected $formBuilder;
    protected $controlBuilder;
    protected $conf;
    protected $currencyRepository;

    /**
     * AdminSettingsMain constructor.
     * @param FormBuilder $form
     * @param ControlBuilder $controlBuilder
     * @param Main $conf
     * @param CurrencyRepository $currencyRepository
     */
    public function __construct(FormBuilder $form, ControlBuilder $controlBuilder, Main $conf,
                                CurrencyRepository $currencyRepository
    )
    {
        $this->formBuilder = $form;
        $this->controlBuilder = $controlBuilder;
        $this->conf = $conf;
        $this->currencyRepository = $currencyRepository;
    }

    /**
     * @return \Core\Form\SettingsForm
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    protected function buildForm(): \Core\Form\SettingsForm
    {
        $form = $this->formBuilder->buildSettingsForm($this->conf, 'main');
        $builder = $this->controlBuilder;

        $currencies = $this->currencyRepository->findByCriteria(
            CurrencyCriteria::create()
        );

        $paginationRows
            = [15 => 15, 30 => 30, 60 => 60, 120 => 120];
        $form
//            ->addHeader('Валюта')
//            ->addField(
//                $builder->buildDropdownUniform('defaultCurrency', Form::prepareDropdown($currencies)),
//                'Валюта по умолчанию', 'required'
//            )
//            ->addField(
//                $builder->buildInputLittle('curencyDisplay'), 'Наименование валюты', 'required', 'Например руб.'
//            )
//            ->addField(
//                $builder->buildInputLittle('curencyDisplayShort'), 'Краткое наименование валюты', 'required', 'Например р.'
//            )
//            ->addHeader('Движение позиций и заказ')
//            ->addField(
//                $builder->buildInputLittle('fakePersent'), 'Фиктивная наценка, %', [], 'для акционных товаров'
//            )
//            ->addField(
//                $builder->buildInputLittle('daysNewGoods'), 'Срок жизни нового товара, дней', null, 'Товар помечается как новинка'
//            )
//            ->addHeader('Изображения')
//            ->addField(
//                $builder->buildInputSmall('imagesServer'), 'Сервер изображений', null,
//                'По умолчанию будет использоваться текущий'
//            )
//            ->addField(
//                $builder->buildInputSmall('thumbPath'), 'Url путь к миниэскизам', null,
//                'Относительно сервера изображений'
//            )
            ->addHeader('Интеграция с сервисами')
            ->addField(
                $builder->buildInputSmall('googleMapApiKey'), 'Google Map Api key'
            )
            ->addField(
                $builder->buildInputSmall('russianPostUrl'), 'Адрес сайта Почта России', null,
                'Для отслеживания почтовых отправлений'
            )
            ->addHeader('Внешний вид и прочее')
            ->addField(
                $builder->buildAutoDropdownMulti('paginationRows', $paginationRows), 'Кол-во товаров для вывода в каталоге'
            );

        return $form;
    }

    public function process(): string
    {

        $form = $this->buildForm();

        return $form->render();
    }

}               