<?php


namespace Shop\Repositories\OrderItem;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\OrderItem\Contracts\OrderItemCriteriaInterface;

class OrderItemCriteria extends AbstractCriteria implements OrderItemCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $sortById;

    /**
     * @var string|null
     */
    protected $filterByorderCode;
    /**
     * @var string|null
     */
    protected $searchByName;
    /**
     * @var string|null
     */
    protected $searchByArticle;
    /**
     * @var string|null
     */
    protected $searchByBrand;
    /**
     * @var int|null
     */
    protected $filterByProviderId;
    /**
     * @var int|null
     */
    protected $filterByStateId;

    /**
     * @var array|null
     */
    protected $filterByOrderIds;

    public static function create()
    {
        return new self();
    }

    /**
     * @return array|null
     */
    public function getFilterByOrderIds(): ?array
    {
        return $this->filterByOrderIds;
    }

    /**
     * @param array|null $filterByOrderIds
     * @return OrderItemCriteria
     */
    public function setFilterByOrderIds(?array $filterByOrderIds): OrderItemCriteria
    {
        $this->filterByOrderIds = $filterByOrderIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortById(): ?string
    {
        return $this->sortById;
    }

    /**
     * @return string|null
     */
    public function getFilterByorderCode(): ?string
    {
        return $this->filterByorderCode;
    }

    /**
     * @param string|null $filterByorderCode
     * @return OrderItemCriteria
     */
    public function setFilterByorderCode(?string $filterByorderCode): OrderItemCriteria
    {
        $this->filterByorderCode = $filterByorderCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return OrderItemCriteria
     */
    public function setSearchByName(?string $searchByName): OrderItemCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByArticle(): ?string
    {
        return $this->searchByArticle;
    }

    /**
     * @param string|null $searchByArticle
     * @return OrderItemCriteria
     */
    public function setSearchByArticle(?string $searchByArticle): OrderItemCriteria
    {
        $this->searchByArticle = $searchByArticle;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByBrand(): ?string
    {
        return $this->searchByBrand;
    }

    /**
     * @param string|null $searchByBrand
     * @return OrderItemCriteria
     */
    public function setSearchByBrand(?string $searchByBrand): OrderItemCriteria
    {
        $this->searchByBrand = $searchByBrand;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByProviderId(): ?int
    {
        return $this->filterByProviderId;
    }

    /**
     * @param int|null $filterByProviderId
     * @return OrderItemCriteria
     */
    public function setFilterByProviderId(?int $filterByProviderId): OrderItemCriteria
    {
        $this->filterByProviderId = $filterByProviderId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByStateId(): ?int
    {
        return $this->filterByStateId;
    }

    /**
     * @param int|null $filterByStateId
     * @return OrderItemCriteria
     */
    public function setFilterByStateId(?int $filterByStateId): OrderItemCriteria
    {
        $this->filterByStateId = $filterByStateId;
        return $this;
    }

}