<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropDownInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Order\OrderQuery;
use Shop\Models\Order\Order as OrderEntity;

/**
 * Description of Payment
 *
 * @author Admin
 */
class OrderOld extends PropelQueryAbstract implements CrudInterface, DropDownInterface,
        \Shop\Contracts\ShopCurrentInterface
{
    use \Shop\Concrete\ShopAuthUserTrait;
    
    public function buildEntity()
    {
        return new OrderEntity;
    }

    /**
     * 
     * @return OrderQuery
     */
    public function buildQuery(): OrderQuery
    {
        
        return OrderQuery::create()
                ->_if($this->curShop)
                    ->filterByShop($this->curShop)
                ->_endif();
    }

    public function getDropdownList():array{
	return $this->buildQuery()
		->find()
		->toKeyValue('id','title');
    }

    /**
     * 
     * @param type $id
     * @return OrderEntity
     */
    public function findById($id){
        return parent::findById($id);
    }
    
    public function findByIds(array $ids){
        return $this->buildQuery()->filterByPrimaryKeys($ids)->find();
    }

    /**
     * 
     * @return OrderEntity
     */
    public function findLast($userId)
    {
        return $this->buildQuery()
                ->filterByCustomerId($userId)
                ->orderById(\Propel\Runtime\ActiveQuery\Criteria::DESC)
                ->findOne();
    }    
    
    /**
     * @deprecated
     * общая сумма всех заказов
     */
    public function summAllOrders($ignoreStates):int
    {

        return (float)$this->getQuery()
                ->useOrderItemQuery()
                    ->withColumn("SUM(price*amount)","summ")
                    ->filterByStateId($ignoreStates,\Propel\Runtime\ActiveQuery\Criteria::NOT_EQUAL)
                ->endUse()
                ->findOne()
                ->getVirtualColumn("summ")
                ;
    }
}