<?php

namespace Shop\Domain\City\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

/**
* Description of City
*
* @author Diamond Code Generator
*/
interface CityCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{
    /**
     * @return int|null
     */
    public function getFilterByCountryId(): ?int;

    /**
     * @return sytring|null
     */
    public function getFilterByName(): ?string;

    /**
     * @return int|null
     */
    public function getFilterByRegionId(): ?int;

    /**
     * @return string|null
     */
    public function getSortByName():?string ;

    /**
     * @return string|null
     */
    public function getSearchByName():?string ;
}           