<?php


namespace Shop\Modules\AdminShops;


use Core\Form\ControlBuilder;
use Diamond\Helpers\Form;
use Shop\Domain\Stock\Contracts\StockEntityInterface;
use Shop\Helpers\Text;
use Shop\Models\PriceAccess\PriceAccessQuery;

trait ColumnFormatTrait
{
    /**
     * @var ControlBuilder
     */
    protected $controlBuilder;

    /**
     * @param StockEntityInterface $stock
     * @return string
     */
    public function formatImages(StockEntityInterface $stock): string
    {
        $found = 0;
        if ($stock->getLogo()) {
            $found++;
        }
        if ($stock->getImage()) {
            $found++;
        }

        return $found > 1 ? Form::buildIcon('images') : ($found > 0 ? Form::buildIcon('image') : '');
    }

    public function formatActive(StockEntityInterface $stock): string
    {
        return \Diamond\Helpers\Formatter::formatYN($stock->getActive(), [
            'Y' => 'color-success',
            'N' => 'color-alert'
        ]);
    }

    /**
     * @param StockEntityInterface $stock
     * @return string
     */
    public function formatManagersCount(StockEntityInterface $stock): string
    {
        return $stock->countManagers();
    }

    /**
     * @param StockEntityInterface $shop
     * @return string
     */
    public function formatContact(StockEntityInterface $shop): string
    {
        if (!$shop->getPhones()) {
            return '';
        }
        return Text::clearText($shop->getPhones(), 130);
    }

    /**
     * @param StockEntityInterface $shop
     * @return mixed
     */
    public function formatAddress(StockEntityInterface $shop): string
    {
        return $shop->getFullAddress();
    }


    /**
     * @param StockEntityInterface $shop
     * @return string
     */
    public function formatName(StockEntityInterface $shop): string
    {
        return $shop->getCountChildrens() > 0 ?
            '<i class="sprite folder interval10right"></i>' .
            $shop->getTitle() : ($shop->getParentId() > 0 ? nbs(7) : '') .
            $shop->getTitle() . ' (' . $shop->getTypeDisplay() . ')';
    }


    /**
     * @param StockEntityInterface $shop
     * @return string
     */
    public function formatContractor(StockEntityInterface $shop): string
    {
        /**
         * @var Customer $contractor
         */
        if ($shop->getContractorId() > 0) {
            $contractor = $shop->getContractor();
            return $contractor->getName() . ', ' . $contractor->getFullAddress() . ', ' . $contractor->getEmail() .
                ', ' . $contractor->getPhone();
        }
        return Form::buildIcon('alert', 'Контрагент не определен.');
    }

    /**
     * @param StockEntityInterface $shop
     * @return string
     */
    public function formatPriceAccess(StockEntityInterface $shop): string
    {
        $results = PriceAccessQuery::create()->filterByShopId($shop->getId())->find();
        $txt = '';
        foreach ($results as $res) {

            $price = $this->priceListRepository->findById((int)$res->getPriceScheetId());
            $txt .= $price->getTitle() . ', ';
        }

        $txt = rtrim($txt, ', ');

        if (empty($txt)) {
            return '';
        }

        $priceList = array_filter(explode(',', $txt));

        return Text::toggleList($priceList);
    }
    
}