<?php

namespace Shop\Modules\AdminBrandsLite;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\ModuleController;
use Shop\Domain\Brand\Contracts\BrandEntityInterface;
use Shop\Modules\AdminBrands\AdminBrands;
use Shop\Modules\Traits\FormatterTrait;

/**
 * Description of AdminBrandsLite
 *
 * @author Diamond Code Generator
 */
class AdminBrandsLite extends AdminBrands
{

    use FormatterTrait;

    /**
     * @param DataTableEngine $table
     */
    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Наименование'))

            )
            ->addColumn(
                (new ColumnTable('alias', 'Псевдоним'))

            )
            ->addColumn(
                (new ColumnTable('desc', 'Описание'))
                    ->setFormat($this, 'formatDesc')

            )
            ->addColumn(
                (new ColumnTable('img', 'Логотип'))
                    ->setFormat($this, 'formatImage')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatSelect')
            );
    }


    /**
     * @param CustomerEntityInterface $customerEntity
     * @return string
     */
    public function formatSelect(BrandEntityInterface $model): string
    {
        return $this->formatRowSelect($model->getName(),'brandId',$model->getId());
    }
}               