<?php

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Position\Position as PositionEntity;
use Shop\Models\Position\PositionQuery;

/**
 * Description of Bonus
 * @deprecated
 * @author Dmitriy
 */
class Position extends PropelQueryAbstract implements CrudInterface, \Shop\Contracts\ShopCurrentInterface
{
    use \Shop\Concrete\ShopAuthUserTrait;

    /**
     * @return PositionQuery
     */
    public function buildQuery()
    {
        return PositionQuery::create()
                ->_if($this->curShop)
                    ->usePricelistSheetQuery()
                        ->usePricelistFileQuery()
                            ->useProviderQuery()
                                ->filterByShop($this->curShop)
                            ->endUse()
                        ->endUse()
                    ->endUse()
                ->_endif()
                ;
    }


    /**
     * 
     * @return PositionEntity
     */
    public function buildEntity()
    {
        return new PositionEntity;
    }

    /**
     * 
     * @param type $id
     * @return PositionEntity
     */
    public function findByRefId($id)
    {
        return $this->buildQuery()->withComplexRate()->findOneByRefId($id);
    }


    /**
     * @param string $id
     * @param int $priceListId
     * @return PositionEntity
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function findByRefIdAndPriceListId(string $id,int $priceListId)
    {
        return $this->buildQuery()->withComplexRate()->filterByPricelistSheetId($priceListId)->filterByRefId($id)->findOne();
    }

    public function findById($id){
	return $this->buildQuery()->withComplexRate()->findPk($id);
    }    
}