<?php

namespace Shop\Modules\AdminBrands;


use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use DiamondTable\TableFactory;
use Shop\Domain\Brand\Contracts\BrandEntityInterface;
use Shop\Helpers\Text;
use Shop\Repositories\Brand\BrandCriteria;
use Shop\Repositories\Brand\BrandRepository;

/**
 * Description of AdminBrands
 *
 * @author Dmitriy
 */
class AdminBrands extends ModuleController
{

    protected $brandRepository;
    protected $tableFactory;
    protected $controlBuilder;

    public function __construct(BrandRepository $brandRepository, TableFactory $tableFactory, ControlBuilder $controlBuilder)
    {
        $this->brandRepository = $brandRepository;
        $this->controlBuilder = $controlBuilder;
        $this->tableFactory = $tableFactory;
    }

    //put your code here
    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->brandRepository, BrandCriteria::create());

        $this->prepareColumns($table);

        $table
            ->addField(
                $this->controlBuilder->buildInput('name')
            )
            ->addField(
                $this->controlBuilder->buildInput('alias'),true,null,'для использования в ЧПУ'
            )
            ->addField(
                $this->controlBuilder
                    ->buildTextEditor('desc')
                    ->setHeight(200)
                    ->setCompact(true),false,null,'Первая картинка в описании будет использоваться в фильтре как логотип'
            )
            ;
        
        $table
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_name')
            )
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_alias')
            )
        ;

        return $table->render();
    }

    /**
     * @param DataTableEngine $table
     */
    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Наименование'))

            )
            ->addColumn(
                (new ColumnTable('alias', 'Псевдоним'))

            )
            ->addColumn(
                (new ColumnTable('desc', 'Описание'))
                    ->setFormat($this, 'formatDesc')

            )
            ->addColumn(
                (new ColumnTable('img', 'Логотип'))
                    ->setFormat($this, 'formatImage')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            )
        ;
    }


    /**
     * @param BrandEntityInterface $brand
     * @return string
     */
    public function formatDesc(BrandEntityInterface $brand): string
    {
        if(!$content = $brand->getDesc()){
            return '';
        }
        return Text::clearText($content);
    }

    /**
     * @param BrandEntityInterface $brand
     * @return string
     */
    public function formatImage(BrandEntityInterface $brand): string
    {
        if(!$content = $brand->getDesc()){
            return '';
        }
        $paths = Text::createImgPathsFromText($content);

        if(count($paths)===0){
            return '';
        }

        return "<img style=\"width:50px\" src=\"".$paths[0]."\"/>";
    }

}