<?php

namespace Shop\Domain\Product\Contracts;

use Propel\Runtime\Collection\ObjectCollection;
use Repo\EntityInterface;
use Shop\Domain\Brand\Contracts\BrandEntityInterface;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Domain\ProductCategory\Contracts\ProductCategoryEntityInterface;

/**
 * Description of Product
 *
 * @author Diamond Code Generator
 */
interface ProductEntityInterface extends EntityInterface
{
    /**
     * @return ProductCategoryEntityInterface
     */
    public function getCategory();

    /**
     * @return BrandEntityInterface
     */
    public function getBrand();

    /**
     * @return string|null
     */
    public function getImg();

    public function getPositionsCount(): int;

    /**
     * @param CustomerEntityInterface $customer
     * @return ObjectCollection
     */
    public function getCurrentPositions(CustomerEntityInterface $customer): ObjectCollection;

    public function setSuperPrice(): void;

    public function isSuperPrice(): bool;

    public function removeSuperPrice(): void;

    public function setHitSale(): void;

    public function isHitSale(): bool;

    public function removeHitSale(): void;

    public function setFavorite(): void;

    public function isFavorite(): bool;

    public function removeFavorite(): void;

    public function setExport(): void;

    public function isExport(): bool;

    public function removeExport(): void;

    /**
     * Получить имя для сео
     * @return string
     */
    public function getProductNameForSeo(): string;
}             