<?php

namespace Shop\Modules\AdminProviders;

use Diamond\Helpers\Form;
use Shop\Domain\Provider\Contracts\ProviderEntityInterface;
use Shop\Models\Customer\Customer;

trait ColumnsFormatTrait
{

    /**
     * @param ProviderEntityInterface $providerEntity
     * @return string
     */
    public function formatContractor(ProviderEntityInterface $providerEntity): string
    {
        /**
         * @var Customer $contractor
         */
        if($providerEntity->getContractorId() > 0){
            $contractor = $providerEntity->getContractor();
            return $contractor->getName() . ', ' .$contractor->getFullAddress() .', '. $contractor->getEmail() .
                ', '.$contractor->getPhone();
        }
        return Form::buildIcon('alert','Контрагент не определен.');
    }

    /**
     * @param ProviderEntityInterface $provider
     * @return mixed
     */
    public function formatCurrency(ProviderEntityInterface $provider)
    {
        return $provider->getCurrency()->getHtmlSign();
    }
}