<?

namespace Shop\Modules\AdminDiscountRules;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminDiscountRules
 *
 * @author Diamond Code Generator
 */
class AdminDiscountRules extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $brandRepo;
    protected $categoryRepo;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\DiscountRule $repo, \Shop\Repositories\Brand $brandRepo,
                         \Shop\Repositories\Category $categoryRepo
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->brandRepo = $brandRepo;
        $this->categoryRepo = $categoryRepo;
    }

    public function process():string
    {

        $table = $this->tableFactory->buildAdminTable("discounts", $this->repo);

        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn((new Column("brandId", "Производитель", 120))->setFn($this, "formatBrand"))
                ->addColumn((new Column("categoryId", "Раздел каталога", 90))->setFn($this, "formatCategory"))
                ->addColumn(new Column("maxPercent", "Максимальная скидка,%", 80))
                ->addColumn(new Column("priority", "Приоритет", 80))
        ;

        $brands = \Shop\Helpers\Form::prepareDropdownWithDef($this->brandRepo, "%");
    $categories = \Shop\Helpers\Form::prepareDropdown($this->categoryRepo,"раздел","getDropdownListWithParent");
    
        $pri = [];
        for ($pr = 0; $pr <= 100; $pr ++ ) {
            $pri [] = $pr;
        }

        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("maxPercent"), null, "required", "0 - отключает все скидки"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("brandId", $brands)
                ))
                ->addField(
                        new Field($this->cBuilder->buildDropdownUniform("categoryId", $categories), "Раздел каталога"))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("priority", $pri)
                ))
        ;

        return $table->render();
    }

    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     */
    public function formatBrand(\Shop\Models\DiscountRule\DiscountRule $rule)
    {
        return $rule->getBrand() ? $rule->getBrand()->getName() : "";
    }

    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     */
    public function formatCategory(\Shop\Models\DiscountRule\DiscountRule $rule)
    {
        return $rule->getCategory() ? $rule->getCategory()->getNameWithParent() : "";
    }

}