<?php

namespace Shop\Modules\AdminPriceFiles;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Diamond\Helpers\Form;
use DiamondTable\TableFactory;
use Shop\Domain\PriceFile\Contracts\PriceFileEntityInterface;
use Shop\Models\PricelistSheet\PricelistSheet;
use Shop\Repositories\PriceFile\PriceFileCriteria;
use Shop\Repositories\PriceFile\PriceFileRepository;
use Shop\Repositories\Provider\ProviderCriteria;
use Shop\Repositories\Provider\ProviderRepository;

/**
 * Description of AdminPriceFiles
 *
 * @author Diamond Code Generator
 */
class AdminPriceFiles extends \Core\ModuleController
{


    protected $priceFileRepository;
    protected $tableFactory;
    protected $controlBuilder;
    protected $providerRepository;

    public function __construct(PriceFileRepository $priceFileRepository, TableFactory $tableFactory,
                                ControlBuilder $controlBuilder, ProviderRepository $providerRepository)
    {
        $this->priceFileRepository = $priceFileRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
        $this->providerRepository = $providerRepository;
    }

    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {

        $providers = $this->providerRepository->findByCriteria(
          ProviderCriteria::create()
        );

        $providersAr = Form::prepareDropdown($providers);

        $table = $this->tableFactory->buildAdminTable($this->priceFileRepository, PriceFileCriteria::create());

        $table
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Название прайс-файла'))
            )
            ->addColumn(
                (new ColumnTable('providerId', 'Поставщик'))
                    ->setFormat($this, 'formatProvider')

            )
            ->addColumn(
                (new ColumnTable('pricelists', 'Прайс-листов'))
                    ->setFormat($this, 'formatPricelistCount')

            )
            ->addColumn(
                (new ColumnTable('positions', 'Позиций'))
                    ->setFormat($this, 'formatPositions')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->controlBuilder->buildInput('name')
            )
            ->addField(
                $this->controlBuilder->buildAutoDropdown('providerId',$providersAr),true
            )
            ;

        return $table->render();
    }

    /**
     * @param PriceFileEntityInterface $priceFile
     * @return string
     */
    public function formatPricelistCount(PriceFileEntityInterface $priceFile): string
    {
        if (!$sheets = $priceFile->getPricelistSheets()) {
            return '';
        }
        return $sheets->count();
    }

    /**
     * @param PriceFileEntityInterface $priceFile
     * @return string
     */
    public function formatPositions(PriceFileEntityInterface $priceFile): string
    {
        /**
         * @var PricelistSheet $sheets
         */
        if (!$sheets = $priceFile->getPricelistSheets()) {
            return '';
        }

        $pos = 0;

        foreach ($sheets as $sheet) {
            if (!$positions = $sheet->getPositions()) {
                continue;
            }
            $pos += $positions->count();
        }

        return $pos;
    }

    /**
     * @param PriceFileEntityInterface $priceFile
     * @return string
     */
    public function formatProvider(PriceFileEntityInterface $priceFile): string
    {
        return $priceFile->getProvider()->getName();
    }

}               