<?php


namespace Shop\Repositories\Provider;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Provider\Contracts\ProviderCriteriaInterface;

class ProviderCriteria extends AbstractCriteria implements ProviderCriteriaInterface
{
    /**
     * @var string|null
     */
    private $filterByName;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param string|null $filterByName
     * @return ProviderCriteria
     */
    public function setFilterByName(?string $filterByName): ProviderCriteriaInterface
    {
        $this->filterByName = $filterByName;
        return $this;
    }

}