<?php


namespace Shop\Repositories\Manager;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Manager\Contracts\ManagerCriteriaInterface;

class ManagerCriteria extends AbstractCriteria implements ManagerCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $sortByName;

    /**
     * @var int|null
     */
    protected $filterByStockId;

    /**
     * @var bool|null
     */
    protected $filterByActiveStock;

    public static function create()
    {
        return new self();
    }

    /**
     * @return bool|null
     */
    public function getFilterByActiveStock(): ?bool
    {
        return $this->filterByActiveStock;
    }

    /**
     * @param bool|null $filterByActiveStock
     * @return ManagerCriteria
     */
    public function setFilterByActiveStock(?bool $filterByActiveStock): ManagerCriteria
    {
        $this->filterByActiveStock = $filterByActiveStock;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return ManagerCriteria
     */
    public function setSortByName(?string $sortByName): ManagerCriteria
    {
        $this->sortByName = $sortByName;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByStockId():?int
    {
        return $this->filterByStockId;
    }

    /**
     * @param int|null $filterByStockId
     * @return $this
     */
    public function setFilterByStockId(?int $filterByStockId)
    {
        $this->filterByStockId = $filterByStockId;
        return $this;
    }

}