<?php

namespace Shop\Domain\ProductCategory;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\ProductCategory\Contracts\ProductCategoryEntityInterface;

/**
 * Description of ProductCategory
 *
 * @author Diamond Code Generator
 */
class ProductCategoryCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return ProductCategoryEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }

    public function getDropdownListWithParent(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getNameWithParentName();
        }

        return $ar;
    }
}               