<?php


namespace Shop\Application\Office\Decorators;


use Shop\Domain\City\Contracts\CityEntityInterface;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Domain\Manager\Contracts\ManagerEntityInterface;

class GuestCustomer implements CustomerEntityInterface
{

    protected $accessPrices = [];

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $phone;

    /**
     * @var int
     */
    protected $cityId;

    /**
     * @var int|null
     */
    protected $id;

    /**
     * @var int
     */
    protected $managerId;

    /**
     * @var ManagerEntityInterface
     */
    protected $manager;

    /**
     * @var int
     */
    protected $groupId;

    /**
     * @var string
     */
    protected $pasword;

    /**
     * @var string|null
     */
    protected $infoHidden;

    /**
     * @var CityEntityInterface
     */
    protected $customerCity;

    public function __construct()
    {
        $this->pasword = md5(time());
        $this->id = time();
    }


    public function getPassword()
    {
        return $this->pasword;
    }

    public function getInfoHidden()
    {
        return $this->infoHidden;
    }

    /**
     * @return CityEntityInterface
     */
    public function getCustomerCity()
    {
        return $this->customerCity;
    }

    /**
     * @param CityEntityInterface $customerCity
     * @return Customer
     */
    public function setCustomerCity(CityEntityInterface $customerCity)
    {
        $this->customerCity = $customerCity;
        return $this;
    }


    /**
     * @return int
     */
    public function getGroupId()
    {
        return $this->groupId;
    }

    /**
     * @return array
     */
    public function getAccessPrices(): array
    {
        return $this->accessPrices;
    }

    /**
     * @param array $accessPrices
     * @return Customer
     */
    public function setAccessPrices(array $accessPrices): GuestCustomer
    {
        $this->accessPrices = $accessPrices;
        return $this;
    }


    /**
     * @param int $groupId
     * @return Customer
     */
    public function setGroupId(int $groupId)
    {
        $this->groupId = $groupId;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    public function setName(string $value)
    {
        $this->name = $value;
        return $this;
    }

    public function setEmail(string $value)
    {
        $this->email = $value;
        return $this;
    }

    public function setPhone(string $value)
    {
        $this->phone = $value;
        return $this;
    }

    public function setCityId(int $value)
    {
        $this->cityId = $value;
        return $this;
    }

    public function getId()
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getManagerId()
    {
        return $this->managerId;
    }

    /**
     * @param int $managerId
     * @return Customer
     */
    public function setManagerId(int $managerId)
    {
        $this->managerId = $managerId;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @return int
     */
    public function getCityId()
    {
        return $this->cityId;
    }

    /**
     * @return ManagerEntityInterface
     */
    public function getManager(): ManagerEntityInterface
    {
        return $this->manager;
    }

    /**
     * @param ManagerEntityInterface $manager
     * @return Customer
     */
    public function setManager(ManagerEntityInterface $manager)
    {
        $this->manager = $manager;
        return $this;
    }

    public function isAuth(): bool
    {
        // TODO: Implement isAuth() method.
    }

    public function isNotifySms(): bool
    {
        // TODO: Implement isNotifySms() method.
    }

    public function getFullAddress(): string
    {
        // TODO: Implement getFullAddress() method.
    }

    public function isNotifyEmail(): bool
    {
        // TODO: Implement isNotifyEmail() method.
    }

    public function getRegisterCode(): string
    {
        // TODO: Implement getRegisterCode() method.
    }

    public function getAccessPriceListScheetIds(): array
    {
        // TODO: Implement getAccessPriceListScheetIds() method.
    }

    public function isProvider(): bool
    {
        // TODO: Implement isProvider() method.
    }

    public function isStock(): bool
    {
        // TODO: Implement isStock() method.
    }

    public function getCustomerGroup()
    {
        // TODO: Implement getCustomerGroup() method.
    }


}