<?php


namespace Shop\Modules\AdminClients;


use Core\Form\ControlBuilder;
use Diamond\Helpers\Form;
use Diamond\Helpers\Formatter;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Diamond\Helpers\Date;
use Shop\Models\Customer\Customer;

trait FormatColumnsTrait
{
    /**
     * @var ControlBuilder
     */
    protected $controlBuilder;

    public function formatActions(CustomerEntityInterface $customer): string
    {
        if ($customer->getPassword() !== null) {
            $title = 'Изменить пароль';
        } else {
            $title = 'Установить пароль';
        }

        //change-password
        return $this->controlBuilder->buildActionMenuAdmin([

            anchor('javascript:void(0);', Form::buildIconText('key.white', $title), [
                'onclick' => "action_row({$customer->getId()},'change-password','$title?')"
            ]),

//            anchor(adaptive_url([
//                'fn' => 'edit',
//                'type' => 'change_password',
//                'id' => $customer->getId()
//            ]), Form::buildIconText('key.white',$title)),
            anchor(adaptive_url([
                'fn' => 'edit',
                'type' => 'autorization',
                'id' => $customer->getId()
            ]), Form::buildIconText('lock.white','Авторизоваться'))

        ], $customer->getId())->render();
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return string
     */
    public function formatcDate(CustomerEntityInterface $customer): string
    {
        return $customer->getRegistred() ? $customer->getRegistred()->format(Date::formatDisplay()) : " - ";
    }

    /**
     * @param \Shop\Models\Customer\Customer $customer
     * @return string
     */
    public function formatAccess(CustomerEntityInterface $customer): string
    {
        return Formatter::formatYN(

            $customer->getPassword() !== null ? 'Y' : 'N', [
                'N' => 'color-alert'
            ]
        );
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatOffice(CustomerEntityInterface $customer): string
    {
        $manager = $customer->getManager();
        return sprintf(
            '%s / %s',
            $manager->getShop()->getTitle(),
            $manager->getName()
        );
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return string
     */
    public function formatAddress(CustomerEntityInterface $customer): string
    {
        $city = $customer->getCustomerCity();
        $region = $city->getCityRegion();

        return sprintf(
            "%s, г.%s", $region->getName(), $city->getName()
        );
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatSmsNotify(CustomerEntityInterface $customer): string
    {
        return $this->getNotifyTypes()[$customer->getNotifyType()];
    }

    /**
     *
     * @return type
     */
    private function getNotifyTypes(): array
    {
        return [
            "sms" => "смс",
            "sms_email" => "смс и email",
            "email" => "email"
        ];
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatScore(CustomerEntityInterface $customer): string
    {

        return $this->bonusUseCase->calculateByCustomer($customer);
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return string
     */
    public function formatLastAuth(CustomerEntityInterface $customer): string
    {
        return $customer->getLastauth() ? $customer->getLastauth()->format(\Diamond\Helpers\Date::formatDisplay()) : " не входил ";
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatGroup(CustomerEntityInterface $customer): string
    {
        return $customer->getCustomerGroup()->getName();
    }

    /**
     * @param CustomerEntityInterface|Customer $customer
     * @return string
     */
    public function formatOrders(CustomerEntityInterface $customer):string{
        return $customer->getOrdersRelatedByCustomerId()->count();
    }
}