<?php


namespace Shop\Repositories\PriceAccess;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\PriceAccess\Contracts\PriceAccessCriteriaInterface;
use Shop\Domain\PriceAccess\PriceAccessCollection;
use Shop\Models\PriceAccess\PriceAccess;
use Shop\Models\PriceAccess\PriceAccessQuery;

class PriceAccessRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
       return new PriceAccess();
    }

    protected function createQuery(): ModelCriteria
    {
        return PriceAccessQuery::create();
    }

    /**
     * @param PaginationInterface|PriceAccessCriteriaInterface $criteria
     * @param ModelCriteria|PriceAccessQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $this->modifyCriteriaForFilterSort($criteria,$dbCriteria);
        $dbCriteria
            ->_if($criteria->getFilterByShopId()!==null)
            ->filterByShopId($criteria->getFilterByShopId() . ' LIKE shop_id', Criteria::CUSTOM)
            ->_endif();
    }

    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new PriceAccessCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }

}