<?php

namespace Shop\Models\Currency\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Currency\Currency as ChildCurrency;
use Shop\Models\Currency\CurrencyQuery as ChildCurrencyQuery;
use Shop\Models\Currency\ShopCurrenciesArchive as ChildShopCurrenciesArchive;
use Shop\Models\Currency\Map\CurrencyTableMap;
use Shop\Models\OrderItem\OrderItem;
use Shop\Models\PricelistSheet\PricelistSheet;
use Shop\Models\Provider\Provider;

/**
 * Base class that represents a query for the 'shop_currencies' table.
 *
 *
 *
 * @method     ChildCurrencyQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildCurrencyQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildCurrencyQuery orderByNative($order = Criteria::ASC) Order by the native column
 * @method     ChildCurrencyQuery orderByPosition($order = Criteria::ASC) Order by the position column
 * @method     ChildCurrencyQuery orderByHtmlSign($order = Criteria::ASC) Order by the html_sign column
 * @method     ChildCurrencyQuery orderByRoundPrice($order = Criteria::ASC) Order by the round_price column
 * @method     ChildCurrencyQuery orderByDisplayed($order = Criteria::ASC) Order by the displayed column
 * @method     ChildCurrencyQuery orderByIso($order = Criteria::ASC) Order by the iso column
 * @method     ChildCurrencyQuery orderByRbkSync($order = Criteria::ASC) Order by the rbk_sync column
 * @method     ChildCurrencyQuery orderByRoundMode($order = Criteria::ASC) Order by the round_mode column
 *
 * @method     ChildCurrencyQuery groupById() Group by the id column
 * @method     ChildCurrencyQuery groupByName() Group by the name column
 * @method     ChildCurrencyQuery groupByNative() Group by the native column
 * @method     ChildCurrencyQuery groupByPosition() Group by the position column
 * @method     ChildCurrencyQuery groupByHtmlSign() Group by the html_sign column
 * @method     ChildCurrencyQuery groupByRoundPrice() Group by the round_price column
 * @method     ChildCurrencyQuery groupByDisplayed() Group by the displayed column
 * @method     ChildCurrencyQuery groupByIso() Group by the iso column
 * @method     ChildCurrencyQuery groupByRbkSync() Group by the rbk_sync column
 * @method     ChildCurrencyQuery groupByRoundMode() Group by the round_mode column
 *
 * @method     ChildCurrencyQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildCurrencyQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildCurrencyQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildCurrencyQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildCurrencyQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildCurrencyQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildCurrencyQuery leftJoinOrderItem($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderItem relation
 * @method     ChildCurrencyQuery rightJoinOrderItem($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderItem relation
 * @method     ChildCurrencyQuery innerJoinOrderItem($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderItem relation
 *
 * @method     ChildCurrencyQuery joinWithOrderItem($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderItem relation
 *
 * @method     ChildCurrencyQuery leftJoinWithOrderItem() Adds a LEFT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildCurrencyQuery rightJoinWithOrderItem() Adds a RIGHT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildCurrencyQuery innerJoinWithOrderItem() Adds a INNER JOIN clause and with to the query using the OrderItem relation
 *
 * @method     ChildCurrencyQuery leftJoinPricelistSheet($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery rightJoinPricelistSheet($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery innerJoinPricelistSheet($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistSheet relation
 *
 * @method     ChildCurrencyQuery joinWithPricelistSheet($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildCurrencyQuery leftJoinWithPricelistSheet() Adds a LEFT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery rightJoinWithPricelistSheet() Adds a RIGHT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery innerJoinWithPricelistSheet() Adds a INNER JOIN clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildCurrencyQuery leftJoinProvider($relationAlias = null) Adds a LEFT JOIN clause to the query using the Provider relation
 * @method     ChildCurrencyQuery rightJoinProvider($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Provider relation
 * @method     ChildCurrencyQuery innerJoinProvider($relationAlias = null) Adds a INNER JOIN clause to the query using the Provider relation
 *
 * @method     ChildCurrencyQuery joinWithProvider($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Provider relation
 *
 * @method     ChildCurrencyQuery leftJoinWithProvider() Adds a LEFT JOIN clause and with to the query using the Provider relation
 * @method     ChildCurrencyQuery rightJoinWithProvider() Adds a RIGHT JOIN clause and with to the query using the Provider relation
 * @method     ChildCurrencyQuery innerJoinWithProvider() Adds a INNER JOIN clause and with to the query using the Provider relation
 *
 * @method     \Shop\Models\OrderItem\OrderItemQuery|\Shop\Models\PricelistSheet\PricelistSheetQuery|\Shop\Models\Provider\ProviderQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildCurrency findOne(ConnectionInterface $con = null) Return the first ChildCurrency matching the query
 * @method     ChildCurrency findOneOrCreate(ConnectionInterface $con = null) Return the first ChildCurrency matching the query, or a new ChildCurrency object populated from the query conditions when no match is found
 *
 * @method     ChildCurrency findOneById(int $id) Return the first ChildCurrency filtered by the id column
 * @method     ChildCurrency findOneByName(string $name) Return the first ChildCurrency filtered by the name column
 * @method     ChildCurrency findOneByNative(string $native) Return the first ChildCurrency filtered by the native column
 * @method     ChildCurrency findOneByPosition(int $position) Return the first ChildCurrency filtered by the position column
 * @method     ChildCurrency findOneByHtmlSign(string $html_sign) Return the first ChildCurrency filtered by the html_sign column
 * @method     ChildCurrency findOneByRoundPrice(int $round_price) Return the first ChildCurrency filtered by the round_price column
 * @method     ChildCurrency findOneByDisplayed(string $displayed) Return the first ChildCurrency filtered by the displayed column
 * @method     ChildCurrency findOneByIso(string $iso) Return the first ChildCurrency filtered by the iso column
 * @method     ChildCurrency findOneByRbkSync(string $rbk_sync) Return the first ChildCurrency filtered by the rbk_sync column
 * @method     ChildCurrency findOneByRoundMode(string $round_mode) Return the first ChildCurrency filtered by the round_mode column *

 * @method     ChildCurrency requirePk($key, ConnectionInterface $con = null) Return the ChildCurrency by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOne(ConnectionInterface $con = null) Return the first ChildCurrency matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCurrency requireOneById(int $id) Return the first ChildCurrency filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByName(string $name) Return the first ChildCurrency filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByNative(string $native) Return the first ChildCurrency filtered by the native column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByPosition(int $position) Return the first ChildCurrency filtered by the position column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByHtmlSign(string $html_sign) Return the first ChildCurrency filtered by the html_sign column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByRoundPrice(int $round_price) Return the first ChildCurrency filtered by the round_price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByDisplayed(string $displayed) Return the first ChildCurrency filtered by the displayed column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByIso(string $iso) Return the first ChildCurrency filtered by the iso column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByRbkSync(string $rbk_sync) Return the first ChildCurrency filtered by the rbk_sync column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByRoundMode(string $round_mode) Return the first ChildCurrency filtered by the round_mode column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCurrency[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildCurrency objects based on current ModelCriteria
 * @method     ChildCurrency[]|ObjectCollection findById(int $id) Return ChildCurrency objects filtered by the id column
 * @method     ChildCurrency[]|ObjectCollection findByName(string $name) Return ChildCurrency objects filtered by the name column
 * @method     ChildCurrency[]|ObjectCollection findByNative(string $native) Return ChildCurrency objects filtered by the native column
 * @method     ChildCurrency[]|ObjectCollection findByPosition(int $position) Return ChildCurrency objects filtered by the position column
 * @method     ChildCurrency[]|ObjectCollection findByHtmlSign(string $html_sign) Return ChildCurrency objects filtered by the html_sign column
 * @method     ChildCurrency[]|ObjectCollection findByRoundPrice(int $round_price) Return ChildCurrency objects filtered by the round_price column
 * @method     ChildCurrency[]|ObjectCollection findByDisplayed(string $displayed) Return ChildCurrency objects filtered by the displayed column
 * @method     ChildCurrency[]|ObjectCollection findByIso(string $iso) Return ChildCurrency objects filtered by the iso column
 * @method     ChildCurrency[]|ObjectCollection findByRbkSync(string $rbk_sync) Return ChildCurrency objects filtered by the rbk_sync column
 * @method     ChildCurrency[]|ObjectCollection findByRoundMode(string $round_mode) Return ChildCurrency objects filtered by the round_mode column
 * @method     ChildCurrency[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class CurrencyQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Currency\Base\CurrencyQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Currency\\Currency', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildCurrencyQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildCurrencyQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildCurrencyQuery) {
            return $criteria;
        }
        $query = new ChildCurrencyQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildCurrency|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CurrencyTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = CurrencyTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCurrency A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `native`, `position`, `html_sign`, `round_price`, `displayed`, `iso`, `rbk_sync`, `round_mode` FROM `shop_currencies` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildCurrency $obj */
            $obj = new ChildCurrency();
            $obj->hydrate($row);
            CurrencyTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildCurrency|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(CurrencyTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(CurrencyTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the native column
     *
     * Example usage:
     * <code>
     * $query->filterByNative('fooValue');   // WHERE native = 'fooValue'
     * $query->filterByNative('%fooValue%', Criteria::LIKE); // WHERE native LIKE '%fooValue%'
     * </code>
     *
     * @param     string $native The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByNative($native = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($native)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_NATIVE, $native, $comparison);
    }

    /**
     * Filter the query on the position column
     *
     * Example usage:
     * <code>
     * $query->filterByPosition(1234); // WHERE position = 1234
     * $query->filterByPosition(array(12, 34)); // WHERE position IN (12, 34)
     * $query->filterByPosition(array('min' => 12)); // WHERE position > 12
     * </code>
     *
     * @param     mixed $position The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByPosition($position = null, $comparison = null)
    {
        if (is_array($position)) {
            $useMinMax = false;
            if (isset($position['min'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_POSITION, $position['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($position['max'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_POSITION, $position['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_POSITION, $position, $comparison);
    }

    /**
     * Filter the query on the html_sign column
     *
     * Example usage:
     * <code>
     * $query->filterByHtmlSign('fooValue');   // WHERE html_sign = 'fooValue'
     * $query->filterByHtmlSign('%fooValue%', Criteria::LIKE); // WHERE html_sign LIKE '%fooValue%'
     * </code>
     *
     * @param     string $htmlSign The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByHtmlSign($htmlSign = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($htmlSign)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_HTML_SIGN, $htmlSign, $comparison);
    }

    /**
     * Filter the query on the round_price column
     *
     * Example usage:
     * <code>
     * $query->filterByRoundPrice(1234); // WHERE round_price = 1234
     * $query->filterByRoundPrice(array(12, 34)); // WHERE round_price IN (12, 34)
     * $query->filterByRoundPrice(array('min' => 12)); // WHERE round_price > 12
     * </code>
     *
     * @param     mixed $roundPrice The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByRoundPrice($roundPrice = null, $comparison = null)
    {
        if (is_array($roundPrice)) {
            $useMinMax = false;
            if (isset($roundPrice['min'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ROUND_PRICE, $roundPrice['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($roundPrice['max'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ROUND_PRICE, $roundPrice['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_ROUND_PRICE, $roundPrice, $comparison);
    }

    /**
     * Filter the query on the displayed column
     *
     * Example usage:
     * <code>
     * $query->filterByDisplayed('fooValue');   // WHERE displayed = 'fooValue'
     * $query->filterByDisplayed('%fooValue%', Criteria::LIKE); // WHERE displayed LIKE '%fooValue%'
     * </code>
     *
     * @param     string $displayed The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByDisplayed($displayed = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($displayed)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_DISPLAYED, $displayed, $comparison);
    }

    /**
     * Filter the query on the iso column
     *
     * Example usage:
     * <code>
     * $query->filterByIso('fooValue');   // WHERE iso = 'fooValue'
     * $query->filterByIso('%fooValue%', Criteria::LIKE); // WHERE iso LIKE '%fooValue%'
     * </code>
     *
     * @param     string $iso The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByIso($iso = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($iso)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_ISO, $iso, $comparison);
    }

    /**
     * Filter the query on the rbk_sync column
     *
     * Example usage:
     * <code>
     * $query->filterByRbkSync('fooValue');   // WHERE rbk_sync = 'fooValue'
     * $query->filterByRbkSync('%fooValue%', Criteria::LIKE); // WHERE rbk_sync LIKE '%fooValue%'
     * </code>
     *
     * @param     string $rbkSync The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByRbkSync($rbkSync = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($rbkSync)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_RBK_SYNC, $rbkSync, $comparison);
    }

    /**
     * Filter the query on the round_mode column
     *
     * Example usage:
     * <code>
     * $query->filterByRoundMode('fooValue');   // WHERE round_mode = 'fooValue'
     * $query->filterByRoundMode('%fooValue%', Criteria::LIKE); // WHERE round_mode LIKE '%fooValue%'
     * </code>
     *
     * @param     string $roundMode The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByRoundMode($roundMode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($roundMode)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CurrencyTableMap::COL_ROUND_MODE, $roundMode, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\OrderItem\OrderItem object
     *
     * @param \Shop\Models\OrderItem\OrderItem|ObjectCollection $orderItem the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByOrderItem($orderItem, $comparison = null)
    {
        if ($orderItem instanceof \Shop\Models\OrderItem\OrderItem) {
            return $this
                ->addUsingAlias(CurrencyTableMap::COL_ID, $orderItem->getCurrencyId(), $comparison);
        } elseif ($orderItem instanceof ObjectCollection) {
            return $this
                ->useOrderItemQuery()
                ->filterByPrimaryKeys($orderItem->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByOrderItem() only accepts arguments of type \Shop\Models\OrderItem\OrderItem or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderItem relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function joinOrderItem($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderItem');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderItem');
        }

        return $this;
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\OrderItem\OrderItemQuery A secondary query class using the current class as primary query
     */
    public function useOrderItemQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderItem($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderItem', '\Shop\Models\OrderItem\OrderItemQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\PricelistSheet\PricelistSheet object
     *
     * @param \Shop\Models\PricelistSheet\PricelistSheet|ObjectCollection $pricelistSheet the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByPricelistSheet($pricelistSheet, $comparison = null)
    {
        if ($pricelistSheet instanceof \Shop\Models\PricelistSheet\PricelistSheet) {
            return $this
                ->addUsingAlias(CurrencyTableMap::COL_ID, $pricelistSheet->getCurrencyId(), $comparison);
        } elseif ($pricelistSheet instanceof ObjectCollection) {
            return $this
                ->usePricelistSheetQuery()
                ->filterByPrimaryKeys($pricelistSheet->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPricelistSheet() only accepts arguments of type \Shop\Models\PricelistSheet\PricelistSheet or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistSheet relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function joinPricelistSheet($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistSheet');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistSheet');
        }

        return $this;
    }

    /**
     * Use the PricelistSheet relation PricelistSheet object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\PricelistSheet\PricelistSheetQuery A secondary query class using the current class as primary query
     */
    public function usePricelistSheetQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPricelistSheet($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistSheet', '\Shop\Models\PricelistSheet\PricelistSheetQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Provider\Provider object
     *
     * @param \Shop\Models\Provider\Provider|ObjectCollection $provider the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCurrencyQuery The current query, for fluid interface
     */
    public function filterByProvider($provider, $comparison = null)
    {
        if ($provider instanceof \Shop\Models\Provider\Provider) {
            return $this
                ->addUsingAlias(CurrencyTableMap::COL_ID, $provider->getCurrencyId(), $comparison);
        } elseif ($provider instanceof ObjectCollection) {
            return $this
                ->useProviderQuery()
                ->filterByPrimaryKeys($provider->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProvider() only accepts arguments of type \Shop\Models\Provider\Provider or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Provider relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function joinProvider($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Provider');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Provider');
        }

        return $this;
    }

    /**
     * Use the Provider relation Provider object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Provider\ProviderQuery A secondary query class using the current class as primary query
     */
    public function useProviderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProvider($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Provider', '\Shop\Models\Provider\ProviderQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildCurrency $currency Object to remove from the list of results
     *
     * @return $this|ChildCurrencyQuery The current query, for fluid interface
     */
    public function prune($currency = null)
    {
        if ($currency) {
            $this->addUsingAlias(CurrencyTableMap::COL_ID, $currency->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePreDelete(ConnectionInterface $con)
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the shop_currencies table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            CurrencyTableMap::clearInstancePool();
            CurrencyTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(CurrencyTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            CurrencyTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            CurrencyTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildShopCurrenciesArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param      ConnectionInterface $con    Connection to use.
     * @param      Boolean $useLittleMemory    Whether or not to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return     int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param boolean True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete($archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

} // CurrencyQuery
