<?php

namespace Shop\Domain\PricePosition\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

/**
* Description of PricePosition
*
* @author Diamond Code Generator
*/
interface PricePositionCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{
    /**
     * @return int|null
     */
    public function getFilterByPricelistSheetId():?int ;

    /**
     * @return string|null
     */
    public function getFilterByRefId():?string ;

    /**
     * @return string|null
     */
    public function getSearchByProductName():?string ;

    /**
     * @param string|null $searchByProductName
     * @return mixed
     */
    public function setSearchByProductName(?string $searchByProductName);

    /**
     * @param string|null $refid
     * @return mixed
     */
    public function setFilterByRefId(?string $refid);

    /**
     * @return int|null
     */
    public function getFilterByProductId(): ?int;
}           