<?php


namespace Shop\Application\Payment\CreateTransaction;


use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;

class CreateTransactionCommand
{
    protected $order;
    protected $resultCode;

    /**
     * CreateTransactionCommand constructor.
     * @param CustomerOrderEntityInterface $order
     * @param TransactionResultCode $resultCode
     */
    public function __construct(CustomerOrderEntityInterface $order, TransactionResultCode $resultCode)
    {
        $this->order = $order;
        $this->resultCode = $resultCode;
    }

    /**
     * @return CustomerOrderEntityInterface
     */
    public function getOrder(): CustomerOrderEntityInterface
    {
        return $this->order;
    }

    /**
     * @return TransactionResultCode
     */
    public function getResultCode(): TransactionResultCode
    {
        return $this->resultCode;
    }




}