<?php


namespace Shop\Modules\AdminClientsLite;


use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Modules\AdminClients\AdminClients;
use Shop\Modules\Traits\FormatterTrait;

class AdminClientsLite extends AdminClients
{
    use FormatterTrait;

    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setSorted(true)
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'ФИО'))->setWidth(15, true)
            )
            ->addColumn(
                (new ColumnTable('email', 'E-mail/Логин'))
                    ->setSorted(true)
            )
            ->addColumn(
                (new ColumnTable('phone', 'Телефон'))->setWidth(10, true)
            )
            ->addColumn(
                (new ColumnTable('registred', 'Дата регистрации'))
                    ->setFormat($this, 'formatcDate')
            )
            ->addColumn(
                (new ColumnTable('groupId', 'Группа'))
                    ->setFormat($this, 'formatGroup')
            )
            ->addColumn(
                (new ColumnTable('address', 'Адрес'))
                    ->setFormat($this, 'formatAddress')
            )
            ->addColumn(
                (new ColumnTable('stockId', 'Офис/Менеджер'))
                    ->setFormat($this, 'formatOffice')
            )
            ->addColumn(
                (new ColumnTable('access', 'Доступ'))
                    ->setFormat($this, 'formatAccess')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatSelect')
            );
    }

    /**
     * @param CustomerEntityInterface $customerEntity
     * @return string
     */
    public function formatSelect(CustomerEntityInterface $customerEntity): string
    {
        return $this->formatRowSelect($customerEntity->getName(), 'customerId', $customerEntity->getId());
    }
}