<?php


namespace Shop\Application\Shopping\SendCustomerOrders;


class SendCustomerOrdersCommand
{
    protected $ids;
    protected $notifyCustomer;
    protected $notifyManager;
    protected $resultOrders;

    /**
     * SendCustomerOrdersCommand constructor.
     * @param array $ids
     * @param bool $notifyCustomer
     * @param bool $notifyManager
     */
    public function __construct(array $ids,
                                bool $notifyCustomer = true,
                                bool $notifyManager = true,
                                ResultOrders $resultOrders)
    {
        $this->ids = $ids;
        $this->notifyManager = $notifyManager;
        $this->notifyCustomer = $notifyCustomer;
        $this->resultOrders = $resultOrders;
    }

    /**
     * @return array
     */
    public function getIds(): array
    {
        return $this->ids;
    }

    /**
     * @return bool
     */
    public function isNotifyCustomer(): bool
    {
        return $this->notifyCustomer;
    }

    /**
     * @return bool
     */
    public function isNotifyManager(): bool
    {
        return $this->notifyManager;
    }

    /**
     * @return ResultOrders
     */
    public function getResultOrders(): ResultOrders
    {
        return $this->resultOrders;
    }




}