<?php


namespace Shop\Application\Office\SendNotifyCustomerPassword;


use Shop\Domain\Customer\Contracts\CustomerEntityInterface;

class SendNotifyCustomerPasswordCommand
{
    /**
     * @var string
     */
    protected $password;

    /**
     * @var CustomerEntityInterface
     */
    protected $customer;

    /**
     * SendNotifyCustomerPasswordCommand constructor.
     * @param CustomerEntityInterface $customer
     * @param string $password
     */
    public function __construct(CustomerEntityInterface $customer, string $password)
    {
        $this->password = $password;
        $this->customer = $customer;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * @return CustomerEntityInterface
     */
    public function getCustomer(): CustomerEntityInterface
    {
        return $this->customer;
    }

}