<?php

namespace Shop\Modules\AdminRegions;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\Registry\Field;
use Diamond\Helpers\Form;
use DiamondTable\TableFactory;
use Shop\Repositories\Country\CountryCriteria;
use Shop\Repositories\Country\CountryRepository;
use Shop\Repositories\Region\RegionCriteria;
use Shop\Repositories\Region\RegionRepository;

/**
 * Description of AdminRegions
 *
 * @author Diamond Code Generator
 */
class AdminRegions extends \Core\ModuleController
{

    protected $regionRepository;
    protected $tableFactory;
    protected $controlBuilder;
    protected $countryRepository;

    /**
     * AdminRegions constructor.
     * @param RegionRepository $regionRepository
     * @param TableFactory $tableFactory
     * @param ControlBuilder $controlBuilder
     * @param CountryRepository $countryRepository
     */
    public function __construct(RegionRepository $regionRepository, TableFactory $tableFactory, ControlBuilder $controlBuilder,
                                CountryRepository $countryRepository)
    {
        $this->regionRepository = $regionRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
        $this->countryRepository = $countryRepository;
    }

    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable(
            $this->regionRepository,
            RegionCriteria::create()
        );

        $countries = $this->countryRepository->findByCriteria(
            CountryCriteria::create()
        );

        $table
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setSorted(true)
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Название'))
                    ->setSorted(true)
            )
            ->addColumn(
                (new ColumnTable('countryId', 'Страна'))
                    ->setFormat($this, 'formatCountry')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->controlBuilder->buildInput('name'), true
            )
            ->addField(
                $this->controlBuilder->buildDropdownUniform('countryId', Form::prepareDropdown($countries)), true
            );

        $table
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_name')
            )
            ->addFilter(
                $this->controlBuilder->buildDropdownUniform('filter_by_countryId', Form::prepareDropdown($countries))
            )
        ;

        return $table->render();

        $table
            ->addField(
                new Field(
                    $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))
            ->addField(
                new Field(
                    $this->cBuilder
                        ->buildDropdownUniform("countryId", \Shop\Helpers\Form::prepareDropdown($this->countryRepo)), null, "required"
                ));

        return $table->render();
    }

    /**
     *
     * @param \Shop\Models\Region\Region $region
     * @return type
     */
    public function formatCountry(\Shop\Models\Region\Region $region)
    {
        return $region->getRegionCountry()->getName();
    }

}