<?php


namespace Shop\Repositories\Region;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Region\Contracts\RegionCriteriaInterface;

class RegionCriteria extends AbstractCriteria implements RegionCriteriaInterface
{

    /**
     * @var int|null
     */
    protected $filterByCountryId;

    /**
     * @var string|null
     */
    protected $sortByName;

    /**
     * @var string|null
     */
    protected $searchByName;

    public static function create()
    {
        return new self();
    }

    /**
     * @return int|null
     */
    public function getFilterByCountryId(): ?int
    {
        return $this->filterByCountryId;
    }

    /**
     * @param int|null $filterByCountryId
     * @return RegionCriteria
     */
    public function setFilterByCountryId(?int $filterByCountryId): RegionCriteria
    {
        $this->filterByCountryId = $filterByCountryId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return RegionCriteria
     */
    public function setSortByName(?string $sortByName): RegionCriteria
    {
        $this->sortByName = $sortByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return RegionCriteria
     */
    public function setSearchByName(?string $searchByName): RegionCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }


}