<?php

namespace Shop\Repositories\DraftProduct;

use Shop\Domain\DraftProduct\Contracts\DraftProductCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class DraftProductCriteria extends AbstractCriteria implements DraftProductCriteriaInterface
{
    /**
     * @var string|null
     */
    private $filterByCustomerId;

    public static function create()
    {
        return new self;
    }

    /**
     * @return string|null
     */
    public function getFilterByCustomerId(): ?string
    {
        return $this->filterByCustomerId;
    }

    /**
     * @param string|null $filterByCustomerId
     * @return DraftProductCriteria
     */
    public function setFilterByCustomerId(?string $filterByCustomerId): DraftProductCriteria
    {
        $this->filterByCustomerId = $filterByCustomerId;
        return $this;
    }

}