<?php

namespace Shop\Models\Brand\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Brand\Brand as ChildBrand;
use Shop\Models\Brand\BrandQuery as ChildBrandQuery;
use Shop\Models\Brand\Map\BrandTableMap;
use Shop\Models\DiscountRule\DiscountRule;
use Shop\Models\DraftProduct\DraftProduct;
use Shop\Models\ImageDefault\ImageDefault;
use Shop\Models\Product\Product;

/**
 * Base class that represents a query for the 'shop_brands' table.
 *
 *
 *
 * @method     ChildBrandQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildBrandQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildBrandQuery orderByAlias($order = Criteria::ASC) Order by the alias column
 * @method     ChildBrandQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 *
 * @method     ChildBrandQuery groupById() Group by the id column
 * @method     ChildBrandQuery groupByName() Group by the name column
 * @method     ChildBrandQuery groupByAlias() Group by the alias column
 * @method     ChildBrandQuery groupByDesc() Group by the desc column
 *
 * @method     ChildBrandQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildBrandQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildBrandQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildBrandQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildBrandQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildBrandQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildBrandQuery leftJoinProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the Product relation
 * @method     ChildBrandQuery rightJoinProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Product relation
 * @method     ChildBrandQuery innerJoinProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the Product relation
 *
 * @method     ChildBrandQuery joinWithProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Product relation
 *
 * @method     ChildBrandQuery leftJoinWithProduct() Adds a LEFT JOIN clause and with to the query using the Product relation
 * @method     ChildBrandQuery rightJoinWithProduct() Adds a RIGHT JOIN clause and with to the query using the Product relation
 * @method     ChildBrandQuery innerJoinWithProduct() Adds a INNER JOIN clause and with to the query using the Product relation
 *
 * @method     ChildBrandQuery leftJoinDiscountRule($relationAlias = null) Adds a LEFT JOIN clause to the query using the DiscountRule relation
 * @method     ChildBrandQuery rightJoinDiscountRule($relationAlias = null) Adds a RIGHT JOIN clause to the query using the DiscountRule relation
 * @method     ChildBrandQuery innerJoinDiscountRule($relationAlias = null) Adds a INNER JOIN clause to the query using the DiscountRule relation
 *
 * @method     ChildBrandQuery joinWithDiscountRule($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the DiscountRule relation
 *
 * @method     ChildBrandQuery leftJoinWithDiscountRule() Adds a LEFT JOIN clause and with to the query using the DiscountRule relation
 * @method     ChildBrandQuery rightJoinWithDiscountRule() Adds a RIGHT JOIN clause and with to the query using the DiscountRule relation
 * @method     ChildBrandQuery innerJoinWithDiscountRule() Adds a INNER JOIN clause and with to the query using the DiscountRule relation
 *
 * @method     ChildBrandQuery leftJoinImageDefault($relationAlias = null) Adds a LEFT JOIN clause to the query using the ImageDefault relation
 * @method     ChildBrandQuery rightJoinImageDefault($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ImageDefault relation
 * @method     ChildBrandQuery innerJoinImageDefault($relationAlias = null) Adds a INNER JOIN clause to the query using the ImageDefault relation
 *
 * @method     ChildBrandQuery joinWithImageDefault($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ImageDefault relation
 *
 * @method     ChildBrandQuery leftJoinWithImageDefault() Adds a LEFT JOIN clause and with to the query using the ImageDefault relation
 * @method     ChildBrandQuery rightJoinWithImageDefault() Adds a RIGHT JOIN clause and with to the query using the ImageDefault relation
 * @method     ChildBrandQuery innerJoinWithImageDefault() Adds a INNER JOIN clause and with to the query using the ImageDefault relation
 *
 * @method     ChildBrandQuery leftJoinDraftProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the DraftProduct relation
 * @method     ChildBrandQuery rightJoinDraftProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the DraftProduct relation
 * @method     ChildBrandQuery innerJoinDraftProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the DraftProduct relation
 *
 * @method     ChildBrandQuery joinWithDraftProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the DraftProduct relation
 *
 * @method     ChildBrandQuery leftJoinWithDraftProduct() Adds a LEFT JOIN clause and with to the query using the DraftProduct relation
 * @method     ChildBrandQuery rightJoinWithDraftProduct() Adds a RIGHT JOIN clause and with to the query using the DraftProduct relation
 * @method     ChildBrandQuery innerJoinWithDraftProduct() Adds a INNER JOIN clause and with to the query using the DraftProduct relation
 *
 * @method     \Shop\Models\Product\ProductQuery|\Shop\Models\DiscountRule\DiscountRuleQuery|\Shop\Models\ImageDefault\ImageDefaultQuery|\Shop\Models\DraftProduct\DraftProductQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildBrand findOne(ConnectionInterface $con = null) Return the first ChildBrand matching the query
 * @method     ChildBrand findOneOrCreate(ConnectionInterface $con = null) Return the first ChildBrand matching the query, or a new ChildBrand object populated from the query conditions when no match is found
 *
 * @method     ChildBrand findOneById(int $id) Return the first ChildBrand filtered by the id column
 * @method     ChildBrand findOneByName(string $name) Return the first ChildBrand filtered by the name column
 * @method     ChildBrand findOneByAlias(string $alias) Return the first ChildBrand filtered by the alias column
 * @method     ChildBrand findOneByDesc(string $desc) Return the first ChildBrand filtered by the desc column *

 * @method     ChildBrand requirePk($key, ConnectionInterface $con = null) Return the ChildBrand by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildBrand requireOne(ConnectionInterface $con = null) Return the first ChildBrand matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildBrand requireOneById(int $id) Return the first ChildBrand filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildBrand requireOneByName(string $name) Return the first ChildBrand filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildBrand requireOneByAlias(string $alias) Return the first ChildBrand filtered by the alias column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildBrand requireOneByDesc(string $desc) Return the first ChildBrand filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildBrand[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildBrand objects based on current ModelCriteria
 * @method     ChildBrand[]|ObjectCollection findById(int $id) Return ChildBrand objects filtered by the id column
 * @method     ChildBrand[]|ObjectCollection findByName(string $name) Return ChildBrand objects filtered by the name column
 * @method     ChildBrand[]|ObjectCollection findByAlias(string $alias) Return ChildBrand objects filtered by the alias column
 * @method     ChildBrand[]|ObjectCollection findByDesc(string $desc) Return ChildBrand objects filtered by the desc column
 * @method     ChildBrand[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class BrandQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Brand\Base\BrandQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Brand\\Brand', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildBrandQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildBrandQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildBrandQuery) {
            return $criteria;
        }
        $query = new ChildBrandQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildBrand|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(BrandTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = BrandTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildBrand A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `alias`, `desc` FROM `shop_brands` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildBrand $obj */
            $obj = new ChildBrand();
            $obj->hydrate($row);
            BrandTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildBrand|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(BrandTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(BrandTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(BrandTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(BrandTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(BrandTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(BrandTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the alias column
     *
     * Example usage:
     * <code>
     * $query->filterByAlias('fooValue');   // WHERE alias = 'fooValue'
     * $query->filterByAlias('%fooValue%', Criteria::LIKE); // WHERE alias LIKE '%fooValue%'
     * </code>
     *
     * @param     string $alias The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function filterByAlias($alias = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($alias)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(BrandTableMap::COL_ALIAS, $alias, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(BrandTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Product\Product object
     *
     * @param \Shop\Models\Product\Product|ObjectCollection $product the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildBrandQuery The current query, for fluid interface
     */
    public function filterByProduct($product, $comparison = null)
    {
        if ($product instanceof \Shop\Models\Product\Product) {
            return $this
                ->addUsingAlias(BrandTableMap::COL_ID, $product->getBrandId(), $comparison);
        } elseif ($product instanceof ObjectCollection) {
            return $this
                ->useProductQuery()
                ->filterByPrimaryKeys($product->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProduct() only accepts arguments of type \Shop\Models\Product\Product or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Product relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function joinProduct($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Product');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Product');
        }

        return $this;
    }

    /**
     * Use the Product relation Product object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Product\ProductQuery A secondary query class using the current class as primary query
     */
    public function useProductQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Product', '\Shop\Models\Product\ProductQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\DiscountRule\DiscountRule object
     *
     * @param \Shop\Models\DiscountRule\DiscountRule|ObjectCollection $discountRule the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildBrandQuery The current query, for fluid interface
     */
    public function filterByDiscountRule($discountRule, $comparison = null)
    {
        if ($discountRule instanceof \Shop\Models\DiscountRule\DiscountRule) {
            return $this
                ->addUsingAlias(BrandTableMap::COL_ID, $discountRule->getBrandId(), $comparison);
        } elseif ($discountRule instanceof ObjectCollection) {
            return $this
                ->useDiscountRuleQuery()
                ->filterByPrimaryKeys($discountRule->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByDiscountRule() only accepts arguments of type \Shop\Models\DiscountRule\DiscountRule or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the DiscountRule relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function joinDiscountRule($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('DiscountRule');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'DiscountRule');
        }

        return $this;
    }

    /**
     * Use the DiscountRule relation DiscountRule object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\DiscountRule\DiscountRuleQuery A secondary query class using the current class as primary query
     */
    public function useDiscountRuleQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinDiscountRule($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'DiscountRule', '\Shop\Models\DiscountRule\DiscountRuleQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\ImageDefault\ImageDefault object
     *
     * @param \Shop\Models\ImageDefault\ImageDefault|ObjectCollection $imageDefault the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildBrandQuery The current query, for fluid interface
     */
    public function filterByImageDefault($imageDefault, $comparison = null)
    {
        if ($imageDefault instanceof \Shop\Models\ImageDefault\ImageDefault) {
            return $this
                ->addUsingAlias(BrandTableMap::COL_ID, $imageDefault->getBrandId(), $comparison);
        } elseif ($imageDefault instanceof ObjectCollection) {
            return $this
                ->useImageDefaultQuery()
                ->filterByPrimaryKeys($imageDefault->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByImageDefault() only accepts arguments of type \Shop\Models\ImageDefault\ImageDefault or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ImageDefault relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function joinImageDefault($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ImageDefault');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ImageDefault');
        }

        return $this;
    }

    /**
     * Use the ImageDefault relation ImageDefault object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\ImageDefault\ImageDefaultQuery A secondary query class using the current class as primary query
     */
    public function useImageDefaultQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinImageDefault($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ImageDefault', '\Shop\Models\ImageDefault\ImageDefaultQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\DraftProduct\DraftProduct object
     *
     * @param \Shop\Models\DraftProduct\DraftProduct|ObjectCollection $draftProduct the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildBrandQuery The current query, for fluid interface
     */
    public function filterByDraftProduct($draftProduct, $comparison = null)
    {
        if ($draftProduct instanceof \Shop\Models\DraftProduct\DraftProduct) {
            return $this
                ->addUsingAlias(BrandTableMap::COL_ID, $draftProduct->getBrandId(), $comparison);
        } elseif ($draftProduct instanceof ObjectCollection) {
            return $this
                ->useDraftProductQuery()
                ->filterByPrimaryKeys($draftProduct->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByDraftProduct() only accepts arguments of type \Shop\Models\DraftProduct\DraftProduct or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the DraftProduct relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function joinDraftProduct($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('DraftProduct');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'DraftProduct');
        }

        return $this;
    }

    /**
     * Use the DraftProduct relation DraftProduct object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\DraftProduct\DraftProductQuery A secondary query class using the current class as primary query
     */
    public function useDraftProductQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDraftProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'DraftProduct', '\Shop\Models\DraftProduct\DraftProductQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildBrand $brand Object to remove from the list of results
     *
     * @return $this|ChildBrandQuery The current query, for fluid interface
     */
    public function prune($brand = null)
    {
        if ($brand) {
            $this->addUsingAlias(BrandTableMap::COL_ID, $brand->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_brands table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(BrandTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            BrandTableMap::clearInstancePool();
            BrandTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(BrandTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(BrandTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            BrandTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            BrandTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // BrandQuery
