<?php

namespace Shop\Models\Brand\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Shop\Models\Brand\Brand as ChildBrand;
use Shop\Models\Brand\BrandQuery as ChildBrandQuery;
use Shop\Models\Brand\Map\BrandTableMap;
use Shop\Models\DiscountRule\DiscountRule;
use Shop\Models\DiscountRule\DiscountRuleQuery;
use Shop\Models\DiscountRule\Base\DiscountRule as BaseDiscountRule;
use Shop\Models\DiscountRule\Map\DiscountRuleTableMap;
use Shop\Models\DraftProduct\DraftProduct;
use Shop\Models\DraftProduct\DraftProductQuery;
use Shop\Models\DraftProduct\Base\DraftProduct as BaseDraftProduct;
use Shop\Models\DraftProduct\Map\DraftProductTableMap;
use Shop\Models\ImageDefault\ImageDefault;
use Shop\Models\ImageDefault\ImageDefaultQuery;
use Shop\Models\ImageDefault\Base\ImageDefault as BaseImageDefault;
use Shop\Models\ImageDefault\Map\ImageDefaultTableMap;
use Shop\Models\Product\Product;
use Shop\Models\Product\ProductQuery;
use Shop\Models\Product\Base\Product as BaseProduct;
use Shop\Models\Product\Map\ProductTableMap;

/**
 * Base class that represents a row from the 'shop_brands' table.
 *
 *
 *
 * @package    propel.generator.Models.Brand.Base
 */
abstract class Brand implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Shop\\Models\\Brand\\Map\\BrandTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     *
     * @var        string
     */
    protected $name;

    /**
     * The value for the alias field.
     *
     * @var        string
     */
    protected $alias;

    /**
     * The value for the desc field.
     *
     * @var        string
     */
    protected $desc;

    /**
     * @var        ObjectCollection|Product[] Collection to store aggregation of Product objects.
     */
    protected $collProducts;
    protected $collProductsPartial;

    /**
     * @var        ObjectCollection|DiscountRule[] Collection to store aggregation of DiscountRule objects.
     */
    protected $collDiscountRules;
    protected $collDiscountRulesPartial;

    /**
     * @var        ObjectCollection|ImageDefault[] Collection to store aggregation of ImageDefault objects.
     */
    protected $collImageDefaults;
    protected $collImageDefaultsPartial;

    /**
     * @var        ObjectCollection|DraftProduct[] Collection to store aggregation of DraftProduct objects.
     */
    protected $collDraftProducts;
    protected $collDraftProductsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Product[]
     */
    protected $productsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|DiscountRule[]
     */
    protected $discountRulesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ImageDefault[]
     */
    protected $imageDefaultsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|DraftProduct[]
     */
    protected $draftProductsScheduledForDeletion = null;

    /**
     * Initializes internal state of Shop\Models\Brand\Base\Brand object.
     */
    public function __construct()
    {
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Brand</code> instance.  If
     * <code>obj</code> is an instance of <code>Brand</code>, delegates to
     * <code>equals(Brand)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Brand The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [alias] column value.
     *
     * @return string
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * Get the [desc] column value.
     *
     * @return string
     */
    public function getDesc()
    {
        return $this->desc;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[BrandTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[BrandTableMap::COL_NAME] = true;
        }

        return $this;
    } // setName()

    /**
     * Set the value of [alias] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function setAlias($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->alias !== $v) {
            $this->alias = $v;
            $this->modifiedColumns[BrandTableMap::COL_ALIAS] = true;
        }

        return $this;
    } // setAlias()

    /**
     * Set the value of [desc] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function setDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->desc !== $v) {
            $this->desc = $v;
            $this->modifiedColumns[BrandTableMap::COL_DESC] = true;
        }

        return $this;
    } // setDesc()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : BrandTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : BrandTableMap::translateFieldName('Name', TableMap::TYPE_PHPNAME, $indexType)];
            $this->name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : BrandTableMap::translateFieldName('Alias', TableMap::TYPE_PHPNAME, $indexType)];
            $this->alias = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : BrandTableMap::translateFieldName('Desc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->desc = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 4; // 4 = BrandTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Models\\Brand\\Brand'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(BrandTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildBrandQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collProducts = null;

            $this->collDiscountRules = null;

            $this->collImageDefaults = null;

            $this->collDraftProducts = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Brand::setDeleted()
     * @see Brand::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(BrandTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildBrandQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(BrandTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                BrandTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->productsScheduledForDeletion !== null) {
                if (!$this->productsScheduledForDeletion->isEmpty()) {
                    \Shop\Models\Product\ProductQuery::create()
                        ->filterByPrimaryKeys($this->productsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->productsScheduledForDeletion = null;
                }
            }

            if ($this->collProducts !== null) {
                foreach ($this->collProducts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->discountRulesScheduledForDeletion !== null) {
                if (!$this->discountRulesScheduledForDeletion->isEmpty()) {
                    foreach ($this->discountRulesScheduledForDeletion as $discountRule) {
                        // need to save related object because we set the relation to null
                        $discountRule->save($con);
                    }
                    $this->discountRulesScheduledForDeletion = null;
                }
            }

            if ($this->collDiscountRules !== null) {
                foreach ($this->collDiscountRules as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->imageDefaultsScheduledForDeletion !== null) {
                if (!$this->imageDefaultsScheduledForDeletion->isEmpty()) {
                    foreach ($this->imageDefaultsScheduledForDeletion as $imageDefault) {
                        // need to save related object because we set the relation to null
                        $imageDefault->save($con);
                    }
                    $this->imageDefaultsScheduledForDeletion = null;
                }
            }

            if ($this->collImageDefaults !== null) {
                foreach ($this->collImageDefaults as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->draftProductsScheduledForDeletion !== null) {
                if (!$this->draftProductsScheduledForDeletion->isEmpty()) {
                    \Shop\Models\DraftProduct\DraftProductQuery::create()
                        ->filterByPrimaryKeys($this->draftProductsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->draftProductsScheduledForDeletion = null;
                }
            }

            if ($this->collDraftProducts !== null) {
                foreach ($this->collDraftProducts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[BrandTableMap::COL_ID] = true;

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(BrandTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(BrandTableMap::COL_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`name`';
        }
        if ($this->isColumnModified(BrandTableMap::COL_ALIAS)) {
            $modifiedColumns[':p' . $index++]  = '`alias`';
        }
        if ($this->isColumnModified(BrandTableMap::COL_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`desc`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_brands` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`name`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`alias`':
                        $stmt->bindValue($identifier, $this->alias, PDO::PARAM_STR);
                        break;
                    case '`desc`':
                        $stmt->bindValue($identifier, $this->desc, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        if ($pk !== null) {
            $this->setId($pk);
        }

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = BrandTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getAlias();
                break;
            case 3:
                return $this->getDesc();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Brand'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Brand'][$this->hashCode()] = true;
        $keys = BrandTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getAlias(),
            $keys[3] => $this->getDesc(),
        );
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->collProducts) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'products';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_productss';
                        break;
                    default:
                        $key = 'Products';
                }

                $result[$key] = $this->collProducts->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collDiscountRules) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'discountRules';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_discount_ruless';
                        break;
                    default:
                        $key = 'DiscountRules';
                }

                $result[$key] = $this->collDiscountRules->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collImageDefaults) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'imageDefaults';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_images_defaults';
                        break;
                    default:
                        $key = 'ImageDefaults';
                }

                $result[$key] = $this->collImageDefaults->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collDraftProducts) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'draftProducts';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_product_draftss';
                        break;
                    default:
                        $key = 'DraftProducts';
                }

                $result[$key] = $this->collDraftProducts->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Shop\Models\Brand\Brand
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = BrandTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Shop\Models\Brand\Brand
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setAlias($value);
                break;
            case 3:
                $this->setDesc($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = BrandTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setName($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setAlias($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setDesc($arr[$keys[3]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Shop\Models\Brand\Brand The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(BrandTableMap::DATABASE_NAME);

        if ($this->isColumnModified(BrandTableMap::COL_ID)) {
            $criteria->add(BrandTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(BrandTableMap::COL_NAME)) {
            $criteria->add(BrandTableMap::COL_NAME, $this->name);
        }
        if ($this->isColumnModified(BrandTableMap::COL_ALIAS)) {
            $criteria->add(BrandTableMap::COL_ALIAS, $this->alias);
        }
        if ($this->isColumnModified(BrandTableMap::COL_DESC)) {
            $criteria->add(BrandTableMap::COL_DESC, $this->desc);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildBrandQuery::create();
        $criteria->add(BrandTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Shop\Models\Brand\Brand (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setAlias($this->getAlias());
        $copyObj->setDesc($this->getDesc());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getProducts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProduct($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getDiscountRules() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addDiscountRule($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getImageDefaults() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addImageDefault($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getDraftProducts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addDraftProduct($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Models\Brand\Brand Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Product' == $relationName) {
            $this->initProducts();
            return;
        }
        if ('DiscountRule' == $relationName) {
            $this->initDiscountRules();
            return;
        }
        if ('ImageDefault' == $relationName) {
            $this->initImageDefaults();
            return;
        }
        if ('DraftProduct' == $relationName) {
            $this->initDraftProducts();
            return;
        }
    }

    /**
     * Clears out the collProducts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProducts()
     */
    public function clearProducts()
    {
        $this->collProducts = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collProducts collection loaded partially.
     */
    public function resetPartialProducts($v = true)
    {
        $this->collProductsPartial = $v;
    }

    /**
     * Initializes the collProducts collection.
     *
     * By default this just sets the collProducts collection to an empty array (like clearcollProducts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProducts($overrideExisting = true)
    {
        if (null !== $this->collProducts && !$overrideExisting) {
            return;
        }

        $collectionClassName = ProductTableMap::getTableMap()->getCollectionClassName();

        $this->collProducts = new $collectionClassName;
        $this->collProducts->setModel('\Shop\Models\Product\Product');
    }

    /**
     * Gets an array of Product objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildBrand is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|Product[] List of Product objects
     * @throws PropelException
     */
    public function getProducts(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collProductsPartial && !$this->isNew();
        if (null === $this->collProducts || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProducts) {
                // return empty collection
                $this->initProducts();
            } else {
                $collProducts = ProductQuery::create(null, $criteria)
                    ->filterByBrand($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collProductsPartial && count($collProducts)) {
                        $this->initProducts(false);

                        foreach ($collProducts as $obj) {
                            if (false == $this->collProducts->contains($obj)) {
                                $this->collProducts->append($obj);
                            }
                        }

                        $this->collProductsPartial = true;
                    }

                    return $collProducts;
                }

                if ($partial && $this->collProducts) {
                    foreach ($this->collProducts as $obj) {
                        if ($obj->isNew()) {
                            $collProducts[] = $obj;
                        }
                    }
                }

                $this->collProducts = $collProducts;
                $this->collProductsPartial = false;
            }
        }

        return $this->collProducts;
    }

    /**
     * Sets a collection of Product objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $products A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function setProducts(Collection $products, ConnectionInterface $con = null)
    {
        /** @var Product[] $productsToDelete */
        $productsToDelete = $this->getProducts(new Criteria(), $con)->diff($products);


        $this->productsScheduledForDeletion = $productsToDelete;

        foreach ($productsToDelete as $productRemoved) {
            $productRemoved->setBrand(null);
        }

        $this->collProducts = null;
        foreach ($products as $product) {
            $this->addProduct($product);
        }

        $this->collProducts = $products;
        $this->collProductsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseProduct objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseProduct objects.
     * @throws PropelException
     */
    public function countProducts(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collProductsPartial && !$this->isNew();
        if (null === $this->collProducts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProducts) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getProducts());
            }

            $query = ProductQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByBrand($this)
                ->count($con);
        }

        return count($this->collProducts);
    }

    /**
     * Method called to associate a Product object to this object
     * through the Product foreign key attribute.
     *
     * @param  Product $l Product
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function addProduct(Product $l)
    {
        if ($this->collProducts === null) {
            $this->initProducts();
            $this->collProductsPartial = true;
        }

        if (!$this->collProducts->contains($l)) {
            $this->doAddProduct($l);

            if ($this->productsScheduledForDeletion and $this->productsScheduledForDeletion->contains($l)) {
                $this->productsScheduledForDeletion->remove($this->productsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Product $product The Product object to add.
     */
    protected function doAddProduct(Product $product)
    {
        $this->collProducts[]= $product;
        $product->setBrand($this);
    }

    /**
     * @param  Product $product The Product object to remove.
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function removeProduct(Product $product)
    {
        if ($this->getProducts()->contains($product)) {
            $pos = $this->collProducts->search($product);
            $this->collProducts->remove($pos);
            if (null === $this->productsScheduledForDeletion) {
                $this->productsScheduledForDeletion = clone $this->collProducts;
                $this->productsScheduledForDeletion->clear();
            }
            $this->productsScheduledForDeletion[]= clone $product;
            $product->setBrand(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Brand is new, it will return
     * an empty collection; or if this Brand has previously
     * been saved, it will retrieve related Products from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Brand.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Product[] List of Product objects
     */
    public function getProductsJoinCategory(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ProductQuery::create(null, $criteria);
        $query->joinWith('Category', $joinBehavior);

        return $this->getProducts($query, $con);
    }

    /**
     * Clears out the collDiscountRules collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDiscountRules()
     */
    public function clearDiscountRules()
    {
        $this->collDiscountRules = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collDiscountRules collection loaded partially.
     */
    public function resetPartialDiscountRules($v = true)
    {
        $this->collDiscountRulesPartial = $v;
    }

    /**
     * Initializes the collDiscountRules collection.
     *
     * By default this just sets the collDiscountRules collection to an empty array (like clearcollDiscountRules());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initDiscountRules($overrideExisting = true)
    {
        if (null !== $this->collDiscountRules && !$overrideExisting) {
            return;
        }

        $collectionClassName = DiscountRuleTableMap::getTableMap()->getCollectionClassName();

        $this->collDiscountRules = new $collectionClassName;
        $this->collDiscountRules->setModel('\Shop\Models\DiscountRule\DiscountRule');
    }

    /**
     * Gets an array of DiscountRule objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildBrand is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|DiscountRule[] List of DiscountRule objects
     * @throws PropelException
     */
    public function getDiscountRules(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collDiscountRulesPartial && !$this->isNew();
        if (null === $this->collDiscountRules || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collDiscountRules) {
                // return empty collection
                $this->initDiscountRules();
            } else {
                $collDiscountRules = DiscountRuleQuery::create(null, $criteria)
                    ->filterByBrand($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collDiscountRulesPartial && count($collDiscountRules)) {
                        $this->initDiscountRules(false);

                        foreach ($collDiscountRules as $obj) {
                            if (false == $this->collDiscountRules->contains($obj)) {
                                $this->collDiscountRules->append($obj);
                            }
                        }

                        $this->collDiscountRulesPartial = true;
                    }

                    return $collDiscountRules;
                }

                if ($partial && $this->collDiscountRules) {
                    foreach ($this->collDiscountRules as $obj) {
                        if ($obj->isNew()) {
                            $collDiscountRules[] = $obj;
                        }
                    }
                }

                $this->collDiscountRules = $collDiscountRules;
                $this->collDiscountRulesPartial = false;
            }
        }

        return $this->collDiscountRules;
    }

    /**
     * Sets a collection of DiscountRule objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $discountRules A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function setDiscountRules(Collection $discountRules, ConnectionInterface $con = null)
    {
        /** @var DiscountRule[] $discountRulesToDelete */
        $discountRulesToDelete = $this->getDiscountRules(new Criteria(), $con)->diff($discountRules);


        $this->discountRulesScheduledForDeletion = $discountRulesToDelete;

        foreach ($discountRulesToDelete as $discountRuleRemoved) {
            $discountRuleRemoved->setBrand(null);
        }

        $this->collDiscountRules = null;
        foreach ($discountRules as $discountRule) {
            $this->addDiscountRule($discountRule);
        }

        $this->collDiscountRules = $discountRules;
        $this->collDiscountRulesPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseDiscountRule objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseDiscountRule objects.
     * @throws PropelException
     */
    public function countDiscountRules(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collDiscountRulesPartial && !$this->isNew();
        if (null === $this->collDiscountRules || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collDiscountRules) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getDiscountRules());
            }

            $query = DiscountRuleQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByBrand($this)
                ->count($con);
        }

        return count($this->collDiscountRules);
    }

    /**
     * Method called to associate a DiscountRule object to this object
     * through the DiscountRule foreign key attribute.
     *
     * @param  DiscountRule $l DiscountRule
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function addDiscountRule(DiscountRule $l)
    {
        if ($this->collDiscountRules === null) {
            $this->initDiscountRules();
            $this->collDiscountRulesPartial = true;
        }

        if (!$this->collDiscountRules->contains($l)) {
            $this->doAddDiscountRule($l);

            if ($this->discountRulesScheduledForDeletion and $this->discountRulesScheduledForDeletion->contains($l)) {
                $this->discountRulesScheduledForDeletion->remove($this->discountRulesScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param DiscountRule $discountRule The DiscountRule object to add.
     */
    protected function doAddDiscountRule(DiscountRule $discountRule)
    {
        $this->collDiscountRules[]= $discountRule;
        $discountRule->setBrand($this);
    }

    /**
     * @param  DiscountRule $discountRule The DiscountRule object to remove.
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function removeDiscountRule(DiscountRule $discountRule)
    {
        if ($this->getDiscountRules()->contains($discountRule)) {
            $pos = $this->collDiscountRules->search($discountRule);
            $this->collDiscountRules->remove($pos);
            if (null === $this->discountRulesScheduledForDeletion) {
                $this->discountRulesScheduledForDeletion = clone $this->collDiscountRules;
                $this->discountRulesScheduledForDeletion->clear();
            }
            $this->discountRulesScheduledForDeletion[]= $discountRule;
            $discountRule->setBrand(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Brand is new, it will return
     * an empty collection; or if this Brand has previously
     * been saved, it will retrieve related DiscountRules from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Brand.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DiscountRule[] List of DiscountRule objects
     */
    public function getDiscountRulesJoinCategory(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DiscountRuleQuery::create(null, $criteria);
        $query->joinWith('Category', $joinBehavior);

        return $this->getDiscountRules($query, $con);
    }

    /**
     * Clears out the collImageDefaults collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addImageDefaults()
     */
    public function clearImageDefaults()
    {
        $this->collImageDefaults = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collImageDefaults collection loaded partially.
     */
    public function resetPartialImageDefaults($v = true)
    {
        $this->collImageDefaultsPartial = $v;
    }

    /**
     * Initializes the collImageDefaults collection.
     *
     * By default this just sets the collImageDefaults collection to an empty array (like clearcollImageDefaults());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initImageDefaults($overrideExisting = true)
    {
        if (null !== $this->collImageDefaults && !$overrideExisting) {
            return;
        }

        $collectionClassName = ImageDefaultTableMap::getTableMap()->getCollectionClassName();

        $this->collImageDefaults = new $collectionClassName;
        $this->collImageDefaults->setModel('\Shop\Models\ImageDefault\ImageDefault');
    }

    /**
     * Gets an array of ImageDefault objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildBrand is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ImageDefault[] List of ImageDefault objects
     * @throws PropelException
     */
    public function getImageDefaults(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collImageDefaultsPartial && !$this->isNew();
        if (null === $this->collImageDefaults || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collImageDefaults) {
                // return empty collection
                $this->initImageDefaults();
            } else {
                $collImageDefaults = ImageDefaultQuery::create(null, $criteria)
                    ->filterByShopBrand($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collImageDefaultsPartial && count($collImageDefaults)) {
                        $this->initImageDefaults(false);

                        foreach ($collImageDefaults as $obj) {
                            if (false == $this->collImageDefaults->contains($obj)) {
                                $this->collImageDefaults->append($obj);
                            }
                        }

                        $this->collImageDefaultsPartial = true;
                    }

                    return $collImageDefaults;
                }

                if ($partial && $this->collImageDefaults) {
                    foreach ($this->collImageDefaults as $obj) {
                        if ($obj->isNew()) {
                            $collImageDefaults[] = $obj;
                        }
                    }
                }

                $this->collImageDefaults = $collImageDefaults;
                $this->collImageDefaultsPartial = false;
            }
        }

        return $this->collImageDefaults;
    }

    /**
     * Sets a collection of ImageDefault objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $imageDefaults A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function setImageDefaults(Collection $imageDefaults, ConnectionInterface $con = null)
    {
        /** @var ImageDefault[] $imageDefaultsToDelete */
        $imageDefaultsToDelete = $this->getImageDefaults(new Criteria(), $con)->diff($imageDefaults);


        $this->imageDefaultsScheduledForDeletion = $imageDefaultsToDelete;

        foreach ($imageDefaultsToDelete as $imageDefaultRemoved) {
            $imageDefaultRemoved->setShopBrand(null);
        }

        $this->collImageDefaults = null;
        foreach ($imageDefaults as $imageDefault) {
            $this->addImageDefault($imageDefault);
        }

        $this->collImageDefaults = $imageDefaults;
        $this->collImageDefaultsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseImageDefault objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseImageDefault objects.
     * @throws PropelException
     */
    public function countImageDefaults(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collImageDefaultsPartial && !$this->isNew();
        if (null === $this->collImageDefaults || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collImageDefaults) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getImageDefaults());
            }

            $query = ImageDefaultQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByShopBrand($this)
                ->count($con);
        }

        return count($this->collImageDefaults);
    }

    /**
     * Method called to associate a ImageDefault object to this object
     * through the ImageDefault foreign key attribute.
     *
     * @param  ImageDefault $l ImageDefault
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function addImageDefault(ImageDefault $l)
    {
        if ($this->collImageDefaults === null) {
            $this->initImageDefaults();
            $this->collImageDefaultsPartial = true;
        }

        if (!$this->collImageDefaults->contains($l)) {
            $this->doAddImageDefault($l);

            if ($this->imageDefaultsScheduledForDeletion and $this->imageDefaultsScheduledForDeletion->contains($l)) {
                $this->imageDefaultsScheduledForDeletion->remove($this->imageDefaultsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ImageDefault $imageDefault The ImageDefault object to add.
     */
    protected function doAddImageDefault(ImageDefault $imageDefault)
    {
        $this->collImageDefaults[]= $imageDefault;
        $imageDefault->setShopBrand($this);
    }

    /**
     * @param  ImageDefault $imageDefault The ImageDefault object to remove.
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function removeImageDefault(ImageDefault $imageDefault)
    {
        if ($this->getImageDefaults()->contains($imageDefault)) {
            $pos = $this->collImageDefaults->search($imageDefault);
            $this->collImageDefaults->remove($pos);
            if (null === $this->imageDefaultsScheduledForDeletion) {
                $this->imageDefaultsScheduledForDeletion = clone $this->collImageDefaults;
                $this->imageDefaultsScheduledForDeletion->clear();
            }
            $this->imageDefaultsScheduledForDeletion[]= $imageDefault;
            $imageDefault->setShopBrand(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Brand is new, it will return
     * an empty collection; or if this Brand has previously
     * been saved, it will retrieve related ImageDefaults from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Brand.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|ImageDefault[] List of ImageDefault objects
     */
    public function getImageDefaultsJoinCategory(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ImageDefaultQuery::create(null, $criteria);
        $query->joinWith('Category', $joinBehavior);

        return $this->getImageDefaults($query, $con);
    }

    /**
     * Clears out the collDraftProducts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDraftProducts()
     */
    public function clearDraftProducts()
    {
        $this->collDraftProducts = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collDraftProducts collection loaded partially.
     */
    public function resetPartialDraftProducts($v = true)
    {
        $this->collDraftProductsPartial = $v;
    }

    /**
     * Initializes the collDraftProducts collection.
     *
     * By default this just sets the collDraftProducts collection to an empty array (like clearcollDraftProducts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initDraftProducts($overrideExisting = true)
    {
        if (null !== $this->collDraftProducts && !$overrideExisting) {
            return;
        }

        $collectionClassName = DraftProductTableMap::getTableMap()->getCollectionClassName();

        $this->collDraftProducts = new $collectionClassName;
        $this->collDraftProducts->setModel('\Shop\Models\DraftProduct\DraftProduct');
    }

    /**
     * Gets an array of DraftProduct objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildBrand is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @throws PropelException
     */
    public function getDraftProducts(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collDraftProducts) {
                // return empty collection
                $this->initDraftProducts();
            } else {
                $collDraftProducts = DraftProductQuery::create(null, $criteria)
                    ->filterByBrand($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collDraftProductsPartial && count($collDraftProducts)) {
                        $this->initDraftProducts(false);

                        foreach ($collDraftProducts as $obj) {
                            if (false == $this->collDraftProducts->contains($obj)) {
                                $this->collDraftProducts->append($obj);
                            }
                        }

                        $this->collDraftProductsPartial = true;
                    }

                    return $collDraftProducts;
                }

                if ($partial && $this->collDraftProducts) {
                    foreach ($this->collDraftProducts as $obj) {
                        if ($obj->isNew()) {
                            $collDraftProducts[] = $obj;
                        }
                    }
                }

                $this->collDraftProducts = $collDraftProducts;
                $this->collDraftProductsPartial = false;
            }
        }

        return $this->collDraftProducts;
    }

    /**
     * Sets a collection of DraftProduct objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $draftProducts A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function setDraftProducts(Collection $draftProducts, ConnectionInterface $con = null)
    {
        /** @var DraftProduct[] $draftProductsToDelete */
        $draftProductsToDelete = $this->getDraftProducts(new Criteria(), $con)->diff($draftProducts);


        $this->draftProductsScheduledForDeletion = $draftProductsToDelete;

        foreach ($draftProductsToDelete as $draftProductRemoved) {
            $draftProductRemoved->setBrand(null);
        }

        $this->collDraftProducts = null;
        foreach ($draftProducts as $draftProduct) {
            $this->addDraftProduct($draftProduct);
        }

        $this->collDraftProducts = $draftProducts;
        $this->collDraftProductsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseDraftProduct objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseDraftProduct objects.
     * @throws PropelException
     */
    public function countDraftProducts(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collDraftProducts) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getDraftProducts());
            }

            $query = DraftProductQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByBrand($this)
                ->count($con);
        }

        return count($this->collDraftProducts);
    }

    /**
     * Method called to associate a DraftProduct object to this object
     * through the DraftProduct foreign key attribute.
     *
     * @param  DraftProduct $l DraftProduct
     * @return $this|\Shop\Models\Brand\Brand The current object (for fluent API support)
     */
    public function addDraftProduct(DraftProduct $l)
    {
        if ($this->collDraftProducts === null) {
            $this->initDraftProducts();
            $this->collDraftProductsPartial = true;
        }

        if (!$this->collDraftProducts->contains($l)) {
            $this->doAddDraftProduct($l);

            if ($this->draftProductsScheduledForDeletion and $this->draftProductsScheduledForDeletion->contains($l)) {
                $this->draftProductsScheduledForDeletion->remove($this->draftProductsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param DraftProduct $draftProduct The DraftProduct object to add.
     */
    protected function doAddDraftProduct(DraftProduct $draftProduct)
    {
        $this->collDraftProducts[]= $draftProduct;
        $draftProduct->setBrand($this);
    }

    /**
     * @param  DraftProduct $draftProduct The DraftProduct object to remove.
     * @return $this|ChildBrand The current object (for fluent API support)
     */
    public function removeDraftProduct(DraftProduct $draftProduct)
    {
        if ($this->getDraftProducts()->contains($draftProduct)) {
            $pos = $this->collDraftProducts->search($draftProduct);
            $this->collDraftProducts->remove($pos);
            if (null === $this->draftProductsScheduledForDeletion) {
                $this->draftProductsScheduledForDeletion = clone $this->collDraftProducts;
                $this->draftProductsScheduledForDeletion->clear();
            }
            $this->draftProductsScheduledForDeletion[]= clone $draftProduct;
            $draftProduct->setBrand(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Brand is new, it will return
     * an empty collection; or if this Brand has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Brand.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     */
    public function getDraftProductsJoinProduct(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Product', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Brand is new, it will return
     * an empty collection; or if this Brand has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Brand.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     */
    public function getDraftProductsJoinCategory(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Category', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Brand is new, it will return
     * an empty collection; or if this Brand has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Brand.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     */
    public function getDraftProductsJoinCustomer(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Customer', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->alias = null;
        $this->desc = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collProducts) {
                foreach ($this->collProducts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDiscountRules) {
                foreach ($this->collDiscountRules as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collImageDefaults) {
                foreach ($this->collImageDefaults as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDraftProducts) {
                foreach ($this->collDraftProducts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collProducts = null;
        $this->collDiscountRules = null;
        $this->collImageDefaults = null;
        $this->collDraftProducts = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(BrandTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
