<?php

namespace Shop\Modules\AdminShops;

use ActiveTable\Contracts\CommandInterface;
use Diamond\Helpers\Form;
use Shop\Domain\Stock\Contracts\StockEntityInterface;
use Shop\Models\Shop\Shop;
use Shop\Repositories\Stock\StockRepository;
use Symfony\Component\HttpFoundation\RedirectResponse;

class ActiveStocksCommand implements CommandInterface
{

    private $stockRepository;

    public function __construct(StockRepository $stockRepository)
    {
        $this->stockRepository = $stockRepository;
    }

    public function process(): void
    {

        $ids = Form::getIdsFromRequest();

        /**
         * @var StockEntityInterface| Shop $stock
         */
        foreach ($ids as $id){
            $stock = $this->stockRepository->findById($id);
            $stock->setActive("Y");
            $this->stockRepository->save($stock);
        }

        Form::addTableNotice(Form::buildSuccessMessage('Торговые точки успешно активированы'));

        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }


}