<?php


namespace Shop\Application\Shopping\CreateFileFromOrderItems;


class CreateFileFromOrderItemsCommand
{
    protected $items;
    protected $fileName;
    protected $resultLink;

    public function __construct(array $items, string $fileName, ResultLink $resultLink)
    {
        $this->items = $items;
        $this->fileName = $fileName;
        $this->resultLink = $resultLink;
    }

    /**
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @return string
     */
    public function getFileName(): string
    {
        return $this->fileName;
    }

    /**
     * @return ResultLink
     */
    public function getResultLink(): ResultLink
    {
        return $this->resultLink;
    }

}