<?php


namespace Shop\Application\Office\CustomerRegistration;



class CustomerRegistrationCommand
{

    /**\
     * @var CustomerRequest
     */
    protected $customerRequest;

    protected $customerResult;


    public function __construct(CustomerRequest $customerRequest, CustomerResult $customerResult)
    {
        $this->customerRequest = $customerRequest;
        $this->customerResult = $customerResult;
    }

    /**
     * @return CustomerRequest
     */
    public function getCustomerRequest(): CustomerRequest
    {
        return $this->customerRequest;
    }

    /**
     * @return CustomerResult
     */
    public function getCustomerResult(): CustomerResult
    {
        return $this->customerResult;
    }


}