<?php

namespace Shop;

use Core\Application\Loader;
use Diamond\Application\Mailing\RecipientsHandlerInterface;
use Shop\Repositories\Customer\CustomerCriteria;
use Shop\Repositories\Customer\CustomerRepository;

class CustomersNoAuthRecipients implements RecipientsHandlerInterface
{
    public function getName(): string
    {
        return 'Магазин / Неавторизованные клиенты';
    }

    public function getMails(): array
    {
        $di = Loader::getInstance()->load('DI');
        /** @var CustomerRepository $userRepository */
        $userRepository = $di->get(CustomerRepository::class);
        $userCollection = $userRepository->findByCriteria(CustomerCriteria::create()->setFilterByOnlyAyth(false));
        $emails = [];
        foreach ($userCollection as $user){
            $emails[] = $user->getEmail();
        }
        return $emails;
    }


}