<?php

namespace Shop\Repositories\DraftProduct;

use Diamond\Repositories\PropelAbstractRepository;
use Shop\Domain\DraftProduct\DraftProductCollection;
use Shop\Models\DraftProduct\DraftProduct;
use Shop\Models\DraftProduct\DraftProductQuery;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class DraftProductRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new DraftProduct();
    }

    protected function createQuery(): ModelCriteria
    {
        return DraftProductQuery::create();
    }

    /**
     * @param PaginationInterface|DraftProductCriteria $criteria
     * @param ModelCriteria|DraftProductQuery $dbCriteria
     * @return void
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getFilterByCustomerId() !== null)
            ->filterByCustomerId($criteria->getFilterByCustomerId())
            ->_endif()
            ;
    }

    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new DraftProductCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }

}