<?php

namespace Shop\Models\DraftProduct\Base;

use \Exception;
use \PDO;
use Shop\Models\DraftProduct\DraftProduct as ChildDraftProduct;
use Shop\Models\DraftProduct\DraftProductQuery as ChildDraftProductQuery;
use Shop\Models\DraftProduct\Map\DraftProductTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Brand\Brand;
use Shop\Models\Category\Category;
use Shop\Models\Customer\Customer;
use Shop\Models\Product\Product;

/**
 * Base class that represents a query for the 'shop_product_drafts' table.
 *
 *
 *
 * @method     ChildDraftProductQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildDraftProductQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildDraftProductQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildDraftProductQuery orderByShortDesc($order = Criteria::ASC) Order by the short_desc column
 * @method     ChildDraftProductQuery orderByArticle($order = Criteria::ASC) Order by the article column
 * @method     ChildDraftProductQuery orderByPrice($order = Criteria::ASC) Order by the price column
 * @method     ChildDraftProductQuery orderByWeight($order = Criteria::ASC) Order by the weight column
 * @method     ChildDraftProductQuery orderByImg($order = Criteria::ASC) Order by the img column
 * @method     ChildDraftProductQuery orderBySpecial($order = Criteria::ASC) Order by the special column
 * @method     ChildDraftProductQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildDraftProductQuery orderByMtTitle($order = Criteria::ASC) Order by the mt_title column
 * @method     ChildDraftProductQuery orderByMtDescription($order = Criteria::ASC) Order by the mt_description column
 * @method     ChildDraftProductQuery orderByMtKeywords($order = Criteria::ASC) Order by the mt_keywords column
 * @method     ChildDraftProductQuery orderByRemains($order = Criteria::ASC) Order by the remains column
 * @method     ChildDraftProductQuery orderBydateUpdate($order = Criteria::ASC) Order by the udate column
 * @method     ChildDraftProductQuery orderBydateCreate($order = Criteria::ASC) Order by the cdate column
 * @method     ChildDraftProductQuery orderBydatePublic($order = Criteria::ASC) Order by the pdate column
 * @method     ChildDraftProductQuery orderByRef($order = Criteria::ASC) Order by the ref column
 * @method     ChildDraftProductQuery orderByMinQuality($order = Criteria::ASC) Order by the min_quality column
 * @method     ChildDraftProductQuery orderBySeazon($order = Criteria::ASC) Order by the seazon column
 * @method     ChildDraftProductQuery orderByProductId($order = Criteria::ASC) Order by the product_id column
 * @method     ChildDraftProductQuery orderByCategoryId($order = Criteria::ASC) Order by the category_id column
 * @method     ChildDraftProductQuery orderByBrandId($order = Criteria::ASC) Order by the brand_id column
 * @method     ChildDraftProductQuery orderByCustomerId($order = Criteria::ASC) Order by the customer_id column
 *
 * @method     ChildDraftProductQuery groupById() Group by the id column
 * @method     ChildDraftProductQuery groupByTitle() Group by the title column
 * @method     ChildDraftProductQuery groupByDesc() Group by the desc column
 * @method     ChildDraftProductQuery groupByShortDesc() Group by the short_desc column
 * @method     ChildDraftProductQuery groupByArticle() Group by the article column
 * @method     ChildDraftProductQuery groupByPrice() Group by the price column
 * @method     ChildDraftProductQuery groupByWeight() Group by the weight column
 * @method     ChildDraftProductQuery groupByImg() Group by the img column
 * @method     ChildDraftProductQuery groupBySpecial() Group by the special column
 * @method     ChildDraftProductQuery groupByActive() Group by the active column
 * @method     ChildDraftProductQuery groupByMtTitle() Group by the mt_title column
 * @method     ChildDraftProductQuery groupByMtDescription() Group by the mt_description column
 * @method     ChildDraftProductQuery groupByMtKeywords() Group by the mt_keywords column
 * @method     ChildDraftProductQuery groupByRemains() Group by the remains column
 * @method     ChildDraftProductQuery groupBydateUpdate() Group by the udate column
 * @method     ChildDraftProductQuery groupBydateCreate() Group by the cdate column
 * @method     ChildDraftProductQuery groupBydatePublic() Group by the pdate column
 * @method     ChildDraftProductQuery groupByRef() Group by the ref column
 * @method     ChildDraftProductQuery groupByMinQuality() Group by the min_quality column
 * @method     ChildDraftProductQuery groupBySeazon() Group by the seazon column
 * @method     ChildDraftProductQuery groupByProductId() Group by the product_id column
 * @method     ChildDraftProductQuery groupByCategoryId() Group by the category_id column
 * @method     ChildDraftProductQuery groupByBrandId() Group by the brand_id column
 * @method     ChildDraftProductQuery groupByCustomerId() Group by the customer_id column
 *
 * @method     ChildDraftProductQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildDraftProductQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildDraftProductQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildDraftProductQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildDraftProductQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildDraftProductQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildDraftProductQuery leftJoinProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the Product relation
 * @method     ChildDraftProductQuery rightJoinProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Product relation
 * @method     ChildDraftProductQuery innerJoinProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the Product relation
 *
 * @method     ChildDraftProductQuery joinWithProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Product relation
 *
 * @method     ChildDraftProductQuery leftJoinWithProduct() Adds a LEFT JOIN clause and with to the query using the Product relation
 * @method     ChildDraftProductQuery rightJoinWithProduct() Adds a RIGHT JOIN clause and with to the query using the Product relation
 * @method     ChildDraftProductQuery innerJoinWithProduct() Adds a INNER JOIN clause and with to the query using the Product relation
 *
 * @method     ChildDraftProductQuery leftJoinCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the Category relation
 * @method     ChildDraftProductQuery rightJoinCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Category relation
 * @method     ChildDraftProductQuery innerJoinCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the Category relation
 *
 * @method     ChildDraftProductQuery joinWithCategory($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Category relation
 *
 * @method     ChildDraftProductQuery leftJoinWithCategory() Adds a LEFT JOIN clause and with to the query using the Category relation
 * @method     ChildDraftProductQuery rightJoinWithCategory() Adds a RIGHT JOIN clause and with to the query using the Category relation
 * @method     ChildDraftProductQuery innerJoinWithCategory() Adds a INNER JOIN clause and with to the query using the Category relation
 *
 * @method     ChildDraftProductQuery leftJoinBrand($relationAlias = null) Adds a LEFT JOIN clause to the query using the Brand relation
 * @method     ChildDraftProductQuery rightJoinBrand($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Brand relation
 * @method     ChildDraftProductQuery innerJoinBrand($relationAlias = null) Adds a INNER JOIN clause to the query using the Brand relation
 *
 * @method     ChildDraftProductQuery joinWithBrand($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Brand relation
 *
 * @method     ChildDraftProductQuery leftJoinWithBrand() Adds a LEFT JOIN clause and with to the query using the Brand relation
 * @method     ChildDraftProductQuery rightJoinWithBrand() Adds a RIGHT JOIN clause and with to the query using the Brand relation
 * @method     ChildDraftProductQuery innerJoinWithBrand() Adds a INNER JOIN clause and with to the query using the Brand relation
 *
 * @method     ChildDraftProductQuery leftJoinCustomer($relationAlias = null) Adds a LEFT JOIN clause to the query using the Customer relation
 * @method     ChildDraftProductQuery rightJoinCustomer($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Customer relation
 * @method     ChildDraftProductQuery innerJoinCustomer($relationAlias = null) Adds a INNER JOIN clause to the query using the Customer relation
 *
 * @method     ChildDraftProductQuery joinWithCustomer($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Customer relation
 *
 * @method     ChildDraftProductQuery leftJoinWithCustomer() Adds a LEFT JOIN clause and with to the query using the Customer relation
 * @method     ChildDraftProductQuery rightJoinWithCustomer() Adds a RIGHT JOIN clause and with to the query using the Customer relation
 * @method     ChildDraftProductQuery innerJoinWithCustomer() Adds a INNER JOIN clause and with to the query using the Customer relation
 *
 * @method     \Shop\Models\Product\ProductQuery|\Shop\Models\Category\CategoryQuery|\Shop\Models\Brand\BrandQuery|\Shop\Models\Customer\CustomerQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildDraftProduct findOne(ConnectionInterface $con = null) Return the first ChildDraftProduct matching the query
 * @method     ChildDraftProduct findOneOrCreate(ConnectionInterface $con = null) Return the first ChildDraftProduct matching the query, or a new ChildDraftProduct object populated from the query conditions when no match is found
 *
 * @method     ChildDraftProduct findOneById(int $id) Return the first ChildDraftProduct filtered by the id column
 * @method     ChildDraftProduct findOneByTitle(string $title) Return the first ChildDraftProduct filtered by the title column
 * @method     ChildDraftProduct findOneByDesc(string $desc) Return the first ChildDraftProduct filtered by the desc column
 * @method     ChildDraftProduct findOneByShortDesc(string $short_desc) Return the first ChildDraftProduct filtered by the short_desc column
 * @method     ChildDraftProduct findOneByArticle(string $article) Return the first ChildDraftProduct filtered by the article column
 * @method     ChildDraftProduct findOneByPrice(string $price) Return the first ChildDraftProduct filtered by the price column
 * @method     ChildDraftProduct findOneByWeight(string $weight) Return the first ChildDraftProduct filtered by the weight column
 * @method     ChildDraftProduct findOneByImg(string $img) Return the first ChildDraftProduct filtered by the img column
 * @method     ChildDraftProduct findOneBySpecial(string $special) Return the first ChildDraftProduct filtered by the special column
 * @method     ChildDraftProduct findOneByActive(string $active) Return the first ChildDraftProduct filtered by the active column
 * @method     ChildDraftProduct findOneByMtTitle(string $mt_title) Return the first ChildDraftProduct filtered by the mt_title column
 * @method     ChildDraftProduct findOneByMtDescription(string $mt_description) Return the first ChildDraftProduct filtered by the mt_description column
 * @method     ChildDraftProduct findOneByMtKeywords(string $mt_keywords) Return the first ChildDraftProduct filtered by the mt_keywords column
 * @method     ChildDraftProduct findOneByRemains(string $remains) Return the first ChildDraftProduct filtered by the remains column
 * @method     ChildDraftProduct findOneBydateUpdate(string $udate) Return the first ChildDraftProduct filtered by the udate column
 * @method     ChildDraftProduct findOneBydateCreate(string $cdate) Return the first ChildDraftProduct filtered by the cdate column
 * @method     ChildDraftProduct findOneBydatePublic(string $pdate) Return the first ChildDraftProduct filtered by the pdate column
 * @method     ChildDraftProduct findOneByRef(int $ref) Return the first ChildDraftProduct filtered by the ref column
 * @method     ChildDraftProduct findOneByMinQuality(string $min_quality) Return the first ChildDraftProduct filtered by the min_quality column
 * @method     ChildDraftProduct findOneBySeazon(string $seazon) Return the first ChildDraftProduct filtered by the seazon column
 * @method     ChildDraftProduct findOneByProductId(int $product_id) Return the first ChildDraftProduct filtered by the product_id column
 * @method     ChildDraftProduct findOneByCategoryId(int $category_id) Return the first ChildDraftProduct filtered by the category_id column
 * @method     ChildDraftProduct findOneByBrandId(int $brand_id) Return the first ChildDraftProduct filtered by the brand_id column
 * @method     ChildDraftProduct findOneByCustomerId(int $customer_id) Return the first ChildDraftProduct filtered by the customer_id column *

 * @method     ChildDraftProduct requirePk($key, ConnectionInterface $con = null) Return the ChildDraftProduct by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOne(ConnectionInterface $con = null) Return the first ChildDraftProduct matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildDraftProduct requireOneById(int $id) Return the first ChildDraftProduct filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByTitle(string $title) Return the first ChildDraftProduct filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByDesc(string $desc) Return the first ChildDraftProduct filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByShortDesc(string $short_desc) Return the first ChildDraftProduct filtered by the short_desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByArticle(string $article) Return the first ChildDraftProduct filtered by the article column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByPrice(string $price) Return the first ChildDraftProduct filtered by the price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByWeight(string $weight) Return the first ChildDraftProduct filtered by the weight column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByImg(string $img) Return the first ChildDraftProduct filtered by the img column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneBySpecial(string $special) Return the first ChildDraftProduct filtered by the special column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByActive(string $active) Return the first ChildDraftProduct filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByMtTitle(string $mt_title) Return the first ChildDraftProduct filtered by the mt_title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByMtDescription(string $mt_description) Return the first ChildDraftProduct filtered by the mt_description column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByMtKeywords(string $mt_keywords) Return the first ChildDraftProduct filtered by the mt_keywords column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByRemains(string $remains) Return the first ChildDraftProduct filtered by the remains column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneBydateUpdate(string $udate) Return the first ChildDraftProduct filtered by the udate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneBydateCreate(string $cdate) Return the first ChildDraftProduct filtered by the cdate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneBydatePublic(string $pdate) Return the first ChildDraftProduct filtered by the pdate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByRef(int $ref) Return the first ChildDraftProduct filtered by the ref column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByMinQuality(string $min_quality) Return the first ChildDraftProduct filtered by the min_quality column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneBySeazon(string $seazon) Return the first ChildDraftProduct filtered by the seazon column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByProductId(int $product_id) Return the first ChildDraftProduct filtered by the product_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByCategoryId(int $category_id) Return the first ChildDraftProduct filtered by the category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByBrandId(int $brand_id) Return the first ChildDraftProduct filtered by the brand_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDraftProduct requireOneByCustomerId(int $customer_id) Return the first ChildDraftProduct filtered by the customer_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildDraftProduct[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildDraftProduct objects based on current ModelCriteria
 * @method     ChildDraftProduct[]|ObjectCollection findById(int $id) Return ChildDraftProduct objects filtered by the id column
 * @method     ChildDraftProduct[]|ObjectCollection findByTitle(string $title) Return ChildDraftProduct objects filtered by the title column
 * @method     ChildDraftProduct[]|ObjectCollection findByDesc(string $desc) Return ChildDraftProduct objects filtered by the desc column
 * @method     ChildDraftProduct[]|ObjectCollection findByShortDesc(string $short_desc) Return ChildDraftProduct objects filtered by the short_desc column
 * @method     ChildDraftProduct[]|ObjectCollection findByArticle(string $article) Return ChildDraftProduct objects filtered by the article column
 * @method     ChildDraftProduct[]|ObjectCollection findByPrice(string $price) Return ChildDraftProduct objects filtered by the price column
 * @method     ChildDraftProduct[]|ObjectCollection findByWeight(string $weight) Return ChildDraftProduct objects filtered by the weight column
 * @method     ChildDraftProduct[]|ObjectCollection findByImg(string $img) Return ChildDraftProduct objects filtered by the img column
 * @method     ChildDraftProduct[]|ObjectCollection findBySpecial(string $special) Return ChildDraftProduct objects filtered by the special column
 * @method     ChildDraftProduct[]|ObjectCollection findByActive(string $active) Return ChildDraftProduct objects filtered by the active column
 * @method     ChildDraftProduct[]|ObjectCollection findByMtTitle(string $mt_title) Return ChildDraftProduct objects filtered by the mt_title column
 * @method     ChildDraftProduct[]|ObjectCollection findByMtDescription(string $mt_description) Return ChildDraftProduct objects filtered by the mt_description column
 * @method     ChildDraftProduct[]|ObjectCollection findByMtKeywords(string $mt_keywords) Return ChildDraftProduct objects filtered by the mt_keywords column
 * @method     ChildDraftProduct[]|ObjectCollection findByRemains(string $remains) Return ChildDraftProduct objects filtered by the remains column
 * @method     ChildDraftProduct[]|ObjectCollection findBydateUpdate(string $udate) Return ChildDraftProduct objects filtered by the udate column
 * @method     ChildDraftProduct[]|ObjectCollection findBydateCreate(string $cdate) Return ChildDraftProduct objects filtered by the cdate column
 * @method     ChildDraftProduct[]|ObjectCollection findBydatePublic(string $pdate) Return ChildDraftProduct objects filtered by the pdate column
 * @method     ChildDraftProduct[]|ObjectCollection findByRef(int $ref) Return ChildDraftProduct objects filtered by the ref column
 * @method     ChildDraftProduct[]|ObjectCollection findByMinQuality(string $min_quality) Return ChildDraftProduct objects filtered by the min_quality column
 * @method     ChildDraftProduct[]|ObjectCollection findBySeazon(string $seazon) Return ChildDraftProduct objects filtered by the seazon column
 * @method     ChildDraftProduct[]|ObjectCollection findByProductId(int $product_id) Return ChildDraftProduct objects filtered by the product_id column
 * @method     ChildDraftProduct[]|ObjectCollection findByCategoryId(int $category_id) Return ChildDraftProduct objects filtered by the category_id column
 * @method     ChildDraftProduct[]|ObjectCollection findByBrandId(int $brand_id) Return ChildDraftProduct objects filtered by the brand_id column
 * @method     ChildDraftProduct[]|ObjectCollection findByCustomerId(int $customer_id) Return ChildDraftProduct objects filtered by the customer_id column
 * @method     ChildDraftProduct[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class DraftProductQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\DraftProduct\Base\DraftProductQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\DraftProduct\\DraftProduct', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildDraftProductQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildDraftProductQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildDraftProductQuery) {
            return $criteria;
        }
        $query = new ChildDraftProductQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildDraftProduct|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(DraftProductTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = DraftProductTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildDraftProduct A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `desc`, `short_desc`, `article`, `price`, `weight`, `img`, `special`, `active`, `mt_title`, `mt_description`, `mt_keywords`, `remains`, `udate`, `cdate`, `pdate`, `ref`, `min_quality`, `seazon`, `product_id`, `category_id`, `brand_id`, `customer_id` FROM `shop_product_drafts` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildDraftProduct $obj */
            $obj = new ChildDraftProduct();
            $obj->hydrate($row);
            DraftProductTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildDraftProduct|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(DraftProductTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(DraftProductTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query on the short_desc column
     *
     * Example usage:
     * <code>
     * $query->filterByShortDesc('fooValue');   // WHERE short_desc = 'fooValue'
     * $query->filterByShortDesc('%fooValue%', Criteria::LIKE); // WHERE short_desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $shortDesc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByShortDesc($shortDesc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($shortDesc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_SHORT_DESC, $shortDesc, $comparison);
    }

    /**
     * Filter the query on the article column
     *
     * Example usage:
     * <code>
     * $query->filterByArticle('fooValue');   // WHERE article = 'fooValue'
     * $query->filterByArticle('%fooValue%', Criteria::LIKE); // WHERE article LIKE '%fooValue%'
     * </code>
     *
     * @param     string $article The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByArticle($article = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($article)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_ARTICLE, $article, $comparison);
    }

    /**
     * Filter the query on the price column
     *
     * Example usage:
     * <code>
     * $query->filterByPrice(1234); // WHERE price = 1234
     * $query->filterByPrice(array(12, 34)); // WHERE price IN (12, 34)
     * $query->filterByPrice(array('min' => 12)); // WHERE price > 12
     * </code>
     *
     * @param     mixed $price The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByPrice($price = null, $comparison = null)
    {
        if (is_array($price)) {
            $useMinMax = false;
            if (isset($price['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_PRICE, $price['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($price['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_PRICE, $price['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_PRICE, $price, $comparison);
    }

    /**
     * Filter the query on the weight column
     *
     * Example usage:
     * <code>
     * $query->filterByWeight(1234); // WHERE weight = 1234
     * $query->filterByWeight(array(12, 34)); // WHERE weight IN (12, 34)
     * $query->filterByWeight(array('min' => 12)); // WHERE weight > 12
     * </code>
     *
     * @param     mixed $weight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByWeight($weight = null, $comparison = null)
    {
        if (is_array($weight)) {
            $useMinMax = false;
            if (isset($weight['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_WEIGHT, $weight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($weight['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_WEIGHT, $weight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_WEIGHT, $weight, $comparison);
    }

    /**
     * Filter the query on the img column
     *
     * Example usage:
     * <code>
     * $query->filterByImg('fooValue');   // WHERE img = 'fooValue'
     * $query->filterByImg('%fooValue%', Criteria::LIKE); // WHERE img LIKE '%fooValue%'
     * </code>
     *
     * @param     string $img The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByImg($img = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($img)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_IMG, $img, $comparison);
    }

    /**
     * Filter the query on the special column
     *
     * Example usage:
     * <code>
     * $query->filterBySpecial('fooValue');   // WHERE special = 'fooValue'
     * $query->filterBySpecial('%fooValue%', Criteria::LIKE); // WHERE special LIKE '%fooValue%'
     * </code>
     *
     * @param     string $special The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterBySpecial($special = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($special)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_SPECIAL, $special, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the mt_title column
     *
     * Example usage:
     * <code>
     * $query->filterByMtTitle('fooValue');   // WHERE mt_title = 'fooValue'
     * $query->filterByMtTitle('%fooValue%', Criteria::LIKE); // WHERE mt_title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtTitle The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByMtTitle($mtTitle = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtTitle)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_MT_TITLE, $mtTitle, $comparison);
    }

    /**
     * Filter the query on the mt_description column
     *
     * Example usage:
     * <code>
     * $query->filterByMtDescription('fooValue');   // WHERE mt_description = 'fooValue'
     * $query->filterByMtDescription('%fooValue%', Criteria::LIKE); // WHERE mt_description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtDescription The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByMtDescription($mtDescription = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtDescription)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_MT_DESCRIPTION, $mtDescription, $comparison);
    }

    /**
     * Filter the query on the mt_keywords column
     *
     * Example usage:
     * <code>
     * $query->filterByMtKeywords('fooValue');   // WHERE mt_keywords = 'fooValue'
     * $query->filterByMtKeywords('%fooValue%', Criteria::LIKE); // WHERE mt_keywords LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtKeywords The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByMtKeywords($mtKeywords = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtKeywords)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_MT_KEYWORDS, $mtKeywords, $comparison);
    }

    /**
     * Filter the query on the remains column
     *
     * Example usage:
     * <code>
     * $query->filterByRemains('fooValue');   // WHERE remains = 'fooValue'
     * $query->filterByRemains('%fooValue%', Criteria::LIKE); // WHERE remains LIKE '%fooValue%'
     * </code>
     *
     * @param     string $remains The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByRemains($remains = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($remains)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_REMAINS, $remains, $comparison);
    }

    /**
     * Filter the query on the udate column
     *
     * Example usage:
     * <code>
     * $query->filterBydateUpdate('2011-03-14'); // WHERE udate = '2011-03-14'
     * $query->filterBydateUpdate('now'); // WHERE udate = '2011-03-14'
     * $query->filterBydateUpdate(array('max' => 'yesterday')); // WHERE udate > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateUpdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterBydateUpdate($dateUpdate = null, $comparison = null)
    {
        if (is_array($dateUpdate)) {
            $useMinMax = false;
            if (isset($dateUpdate['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_UDATE, $dateUpdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateUpdate['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_UDATE, $dateUpdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_UDATE, $dateUpdate, $comparison);
    }

    /**
     * Filter the query on the cdate column
     *
     * Example usage:
     * <code>
     * $query->filterBydateCreate('2011-03-14'); // WHERE cdate = '2011-03-14'
     * $query->filterBydateCreate('now'); // WHERE cdate = '2011-03-14'
     * $query->filterBydateCreate(array('max' => 'yesterday')); // WHERE cdate > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateCreate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterBydateCreate($dateCreate = null, $comparison = null)
    {
        if (is_array($dateCreate)) {
            $useMinMax = false;
            if (isset($dateCreate['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_CDATE, $dateCreate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateCreate['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_CDATE, $dateCreate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_CDATE, $dateCreate, $comparison);
    }

    /**
     * Filter the query on the pdate column
     *
     * Example usage:
     * <code>
     * $query->filterBydatePublic('2011-03-14'); // WHERE pdate = '2011-03-14'
     * $query->filterBydatePublic('now'); // WHERE pdate = '2011-03-14'
     * $query->filterBydatePublic(array('max' => 'yesterday')); // WHERE pdate > '2011-03-13'
     * </code>
     *
     * @param     mixed $datePublic The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterBydatePublic($datePublic = null, $comparison = null)
    {
        if (is_array($datePublic)) {
            $useMinMax = false;
            if (isset($datePublic['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_PDATE, $datePublic['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datePublic['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_PDATE, $datePublic['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_PDATE, $datePublic, $comparison);
    }

    /**
     * Filter the query on the ref column
     *
     * Example usage:
     * <code>
     * $query->filterByRef(1234); // WHERE ref = 1234
     * $query->filterByRef(array(12, 34)); // WHERE ref IN (12, 34)
     * $query->filterByRef(array('min' => 12)); // WHERE ref > 12
     * </code>
     *
     * @param     mixed $ref The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByRef($ref = null, $comparison = null)
    {
        if (is_array($ref)) {
            $useMinMax = false;
            if (isset($ref['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_REF, $ref['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($ref['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_REF, $ref['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_REF, $ref, $comparison);
    }

    /**
     * Filter the query on the min_quality column
     *
     * Example usage:
     * <code>
     * $query->filterByMinQuality('fooValue');   // WHERE min_quality = 'fooValue'
     * $query->filterByMinQuality('%fooValue%', Criteria::LIKE); // WHERE min_quality LIKE '%fooValue%'
     * </code>
     *
     * @param     string $minQuality The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByMinQuality($minQuality = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($minQuality)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_MIN_QUALITY, $minQuality, $comparison);
    }

    /**
     * Filter the query on the seazon column
     *
     * Example usage:
     * <code>
     * $query->filterBySeazon('fooValue');   // WHERE seazon = 'fooValue'
     * $query->filterBySeazon('%fooValue%', Criteria::LIKE); // WHERE seazon LIKE '%fooValue%'
     * </code>
     *
     * @param     string $seazon The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterBySeazon($seazon = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($seazon)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_SEAZON, $seazon, $comparison);
    }

    /**
     * Filter the query on the product_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProductId(1234); // WHERE product_id = 1234
     * $query->filterByProductId(array(12, 34)); // WHERE product_id IN (12, 34)
     * $query->filterByProductId(array('min' => 12)); // WHERE product_id > 12
     * </code>
     *
     * @see       filterByProduct()
     *
     * @param     mixed $productId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByProductId($productId = null, $comparison = null)
    {
        if (is_array($productId)) {
            $useMinMax = false;
            if (isset($productId['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_PRODUCT_ID, $productId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($productId['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_PRODUCT_ID, $productId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_PRODUCT_ID, $productId, $comparison);
    }

    /**
     * Filter the query on the category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryId(1234); // WHERE category_id = 1234
     * $query->filterByCategoryId(array(12, 34)); // WHERE category_id IN (12, 34)
     * $query->filterByCategoryId(array('min' => 12)); // WHERE category_id > 12
     * </code>
     *
     * @see       filterByCategory()
     *
     * @param     mixed $categoryId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByCategoryId($categoryId = null, $comparison = null)
    {
        if (is_array($categoryId)) {
            $useMinMax = false;
            if (isset($categoryId['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_CATEGORY_ID, $categoryId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($categoryId['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_CATEGORY_ID, $categoryId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_CATEGORY_ID, $categoryId, $comparison);
    }

    /**
     * Filter the query on the brand_id column
     *
     * Example usage:
     * <code>
     * $query->filterByBrandId(1234); // WHERE brand_id = 1234
     * $query->filterByBrandId(array(12, 34)); // WHERE brand_id IN (12, 34)
     * $query->filterByBrandId(array('min' => 12)); // WHERE brand_id > 12
     * </code>
     *
     * @see       filterByBrand()
     *
     * @param     mixed $brandId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByBrandId($brandId = null, $comparison = null)
    {
        if (is_array($brandId)) {
            $useMinMax = false;
            if (isset($brandId['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_BRAND_ID, $brandId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($brandId['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_BRAND_ID, $brandId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_BRAND_ID, $brandId, $comparison);
    }

    /**
     * Filter the query on the customer_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomerId(1234); // WHERE customer_id = 1234
     * $query->filterByCustomerId(array(12, 34)); // WHERE customer_id IN (12, 34)
     * $query->filterByCustomerId(array('min' => 12)); // WHERE customer_id > 12
     * </code>
     *
     * @see       filterByCustomer()
     *
     * @param     mixed $customerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByCustomerId($customerId = null, $comparison = null)
    {
        if (is_array($customerId)) {
            $useMinMax = false;
            if (isset($customerId['min'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_CUSTOMER_ID, $customerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($customerId['max'])) {
                $this->addUsingAlias(DraftProductTableMap::COL_CUSTOMER_ID, $customerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DraftProductTableMap::COL_CUSTOMER_ID, $customerId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Product\Product object
     *
     * @param \Shop\Models\Product\Product|ObjectCollection $product The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByProduct($product, $comparison = null)
    {
        if ($product instanceof \Shop\Models\Product\Product) {
            return $this
                ->addUsingAlias(DraftProductTableMap::COL_PRODUCT_ID, $product->getId(), $comparison);
        } elseif ($product instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(DraftProductTableMap::COL_PRODUCT_ID, $product->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProduct() only accepts arguments of type \Shop\Models\Product\Product or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Product relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function joinProduct($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Product');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Product');
        }

        return $this;
    }

    /**
     * Use the Product relation Product object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Product\ProductQuery A secondary query class using the current class as primary query
     */
    public function useProductQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Product', '\Shop\Models\Product\ProductQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Category\Category object
     *
     * @param \Shop\Models\Category\Category|ObjectCollection $category The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByCategory($category, $comparison = null)
    {
        if ($category instanceof \Shop\Models\Category\Category) {
            return $this
                ->addUsingAlias(DraftProductTableMap::COL_CATEGORY_ID, $category->getId(), $comparison);
        } elseif ($category instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(DraftProductTableMap::COL_CATEGORY_ID, $category->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCategory() only accepts arguments of type \Shop\Models\Category\Category or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Category relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function joinCategory($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Category');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Category');
        }

        return $this;
    }

    /**
     * Use the Category relation Category object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Category\CategoryQuery A secondary query class using the current class as primary query
     */
    public function useCategoryQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Category', '\Shop\Models\Category\CategoryQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Brand\Brand object
     *
     * @param \Shop\Models\Brand\Brand|ObjectCollection $brand The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByBrand($brand, $comparison = null)
    {
        if ($brand instanceof \Shop\Models\Brand\Brand) {
            return $this
                ->addUsingAlias(DraftProductTableMap::COL_BRAND_ID, $brand->getId(), $comparison);
        } elseif ($brand instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(DraftProductTableMap::COL_BRAND_ID, $brand->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByBrand() only accepts arguments of type \Shop\Models\Brand\Brand or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Brand relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function joinBrand($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Brand');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Brand');
        }

        return $this;
    }

    /**
     * Use the Brand relation Brand object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Brand\BrandQuery A secondary query class using the current class as primary query
     */
    public function useBrandQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinBrand($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Brand', '\Shop\Models\Brand\BrandQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Customer\Customer object
     *
     * @param \Shop\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildDraftProductQuery The current query, for fluid interface
     */
    public function filterByCustomer($customer, $comparison = null)
    {
        if ($customer instanceof \Shop\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(DraftProductTableMap::COL_CUSTOMER_ID, $customer->getId(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(DraftProductTableMap::COL_CUSTOMER_ID, $customer->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCustomer() only accepts arguments of type \Shop\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Customer relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function joinCustomer($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Customer');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Customer');
        }

        return $this;
    }

    /**
     * Use the Customer relation Customer object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useCustomerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomer($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Customer', '\Shop\Models\Customer\CustomerQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildDraftProduct $draftProduct Object to remove from the list of results
     *
     * @return $this|ChildDraftProductQuery The current query, for fluid interface
     */
    public function prune($draftProduct = null)
    {
        if ($draftProduct) {
            $this->addUsingAlias(DraftProductTableMap::COL_ID, $draftProduct->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_product_drafts table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DraftProductTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            DraftProductTableMap::clearInstancePool();
            DraftProductTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DraftProductTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(DraftProductTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            DraftProductTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            DraftProductTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // DraftProductQuery
