<?php

namespace Shop\Application\Shopping\PrepareCustomerOrderDataForReport;

use Core\Helpers\Date;
use Propel\Runtime\Map\TableMap;
use Shop\Application\Office\OfficeService;
use Shop\Application\Shopping\CreateFileFromOrderItems\CreateFileFromOrderItemsCommand;
use Shop\Application\Shopping\CreateFileFromOrderItems\ResultLink;
use Shop\Config\Main;
use Shop\Models\Currency\Currency;
use spaceonfire\CommandBus\CommandBus;

class PrepareCustomerOrderDataForReportHandler
{

    protected $mainConf;
    protected $officeService;
    protected $commandBus;

    /**
     * PrepareProviderOrderDataForReportHandler constructor.
     * @param Main $main
     * @param CommandBus $commandBus
     * @param OfficeService $officeService
     */
    public function __construct(Main $main,
                                CommandBus $commandBus,
                                OfficeService $officeService)
    {
        $this->mainConf = $main;
        $this->officeService = $officeService;
        $this->commandBus = $commandBus;
    }

    public function handle(PrepareCustomerOrderDataForReportCommand $command): void
    {
        $order = $command->getOrder();

        /**
         * @var Currency $currency
         */
        $currency = $order->getOrderItems()->getFirst()->getCurrency();

        $currencyDisplay = $currency->getHtmlSign();

        $stockContractor = $order->getContractor();

        //dd($stockContractor);

        try {
            $logoPath = $this->officeService->getStockLogoPath(
                $stockContractor->getStockIfContractor($this->mainConf->getDefaultContractorGroup()));
        } catch (\RuntimeException $ex) {
            $logoPath = null;
        }

        $code = trim($order->getPostCode());



        $data = [
            'date' => $order->getDatetime(Date::formatDisplay()),
            'order_date' => $order->getDatetime(Date::formatDisplay()),
            'state' => $order->getState()->getTitle(),
            'post_code' => $code,
            'ruspost_link' => anchor($this->mainConf->getRussianPostUrl() . '#' . $code, $code,
                [
                    'title' => 'перейти на сайт почты',
                    'target' => '_blank'
                ]
            ),

            'customer_name' => $order->getCustomer()->getName(),
            'customer' => $order->getCustomer(),
            'manager'    => $order->getCustomer()->getManager(),


            'order_code' => $order->getOrderCode(),

            'group' => $order->getCustomer()->getCustomerGroup(),
            'stock_logo_path' => !$logoPath ? null : getenv('BASE_URL') . $logoPath,
            'order' => $order->toArray(TableMap::TYPE_FIELDNAME),
            'order_items' => $order->getOrderItems()->toArray(null, false, TableMap::TYPE_FIELDNAME),
            'stock' => $stockContractor->toArray(TableMap::TYPE_FIELDNAME),
            'payment' => $order->getPayment()->toArray(TableMap::TYPE_FIELDNAME),
            'sum' => $order->getSumm(),
            'order_finalSum' => $order->getOrderFinalSumm(),
            'discountSum' => $order->getDiscountSumm(),
            'discount_percent' => $order->getDiscountPercent(),

            'currency' => $currencyDisplay,
            'attach'    =>  []
        ];

        $result = new ResultLink();

        $this->commandBus->handle(new CreateFileFromOrderItemsCommand(
            $data['order_items'],
            'customer_order_' .$order->getOrderCode(),
            $result
        ));

        $data['attach'] = (array)$result->getFileLink();

        $command->getResult()->setData($data);
    }

}