<?php

namespace Shop\Domain\Basket\Contracts;

use Repo\EntityInterface;
use Shop\Domain\Basket\BasketItem;

/**
* Description of Brand
*
* @author Diamond Code Generator
*/
interface BasketEntityInterface extends EntityInterface
{
    /**
     * @return array
     */
    public function getItems(): array ;

    /**
     * @return int
     */
    public function getCount(): int;

    /**
     * @return float
     */
    public function getSum(): float ;

    /**
     * @param string $ref
     * @return int
     */
    public function itemExistByRef(string $ref): int;

    /**
     * очистка корзины
     */
    public function clear(): void ;


    public function addItem(BasketItem $item): void;

}             