<?php

namespace Shop\Repositories\Brand;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Brand\Contracts\BrandCriteriaInterface;

/**
 * Description of ProductCriteria
 *
 * @author Admin
 */
class BrandCriteria extends AbstractCriteria implements BrandCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var string|null
     */
    protected $filterByName;

    /**
     * @var string|null
     */
    protected $searchByAlias;

    /**
     * @var int|null
     */
    protected $filterByProductCategoryId;

    /**
     * @var string|null
     */
    protected $searchByProductName;

    /**
     * @var string|null
     */
    protected $filterByAlias;

    /**
     * @var array|null
     */
    protected $filterByPriceListScheetIds;

    /**
     * @var array|null
     */
    protected $filterByWeights;

    /**
     * @var array|null
     */
    protected $filterByDestinations;

    /**
     * @var string|null
     */
    protected $sortByName;

    /**
     * @return string|null
     */
    public function getSearchByProductName(): ?string
    {
        return $this->searchByProductName;
    }

    /**
     * @param string|null $searchByProductName
     * @return BrandCriteriaInterface
     */
    public function setSearchByProductName(?string $searchByProductName): BrandCriteriaInterface
    {
        $this->searchByProductName = $searchByProductName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param string|null $filterByName
     * @return BrandCriteriaInterface
     */
    public function setFilterByName(?string $filterByName):BrandCriteriaInterface
    {
        $this->filterByName = $filterByName;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getFilterByDestinations(): ?array
    {
        return $this->filterByDestinations;
    }

    /**
     * @param array|null $filterByDestinations
     * @return BrandCriteriaInterface
     */
    public function setFilterByDestinations(?array $filterByDestinations):BrandCriteriaInterface
    {
        $this->filterByDestinations = $filterByDestinations;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByWeights(): ?array
    {
        return $this->filterByWeights;
    }

    /**
     * @param array|null $filterByWeights
     * @return BrandCriteriaInterface
     */
    public function setFilterByWeights(?array $filterByWeights):BrandCriteriaInterface
    {
        $this->filterByWeights = $filterByWeights;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return BrandCriteriaInterface
     */
    public function setSortByName(?string $sortByName):BrandCriteriaInterface
    {
        $this->sortByName = $sortByName;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByPriceListScheetIds(): ?array
    {
        return $this->filterByPriceListScheetIds;
    }

    /**
     * @param array|null $filterByPriceListScheetIds
     * @return BrandCriteriaInterface
     */
    public function setFilterByPriceListScheetIds(?array $filterByPriceListScheetIds):BrandCriteriaInterface
    {
        $this->filterByPriceListScheetIds = $filterByPriceListScheetIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByAlias(): ?string
    {
        return $this->filterByAlias;
    }

    /**
     * @param string|null $filterByAlias
     * @return BrandCriteriaInterface
     */
    public function setFilterByAlias(?string $filterByAlias):BrandCriteriaInterface
    {
        $this->filterByAlias = $filterByAlias;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByProductCategoryId(): ?int
    {
        return $this->filterByProductCategoryId;
    }

    /**
     * @param int|null $filterByProductCategoryInt
     * @return BrandCriteriaInterface
     */
    public function setFilterByProductCategoryId(?int $filterByProductCategoryInt):BrandCriteriaInterface
    {
        $this->filterByProductCategoryId = $filterByProductCategoryInt;
        return $this;
    }


    /**
     * @return mixed|BrandCriteria
     */
    public static function create()
    {
        return new self;
    }


    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return BrandCriteriaInterface
     */
    public function setSearchByName(?string $searchByName):BrandCriteriaInterface
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByAlias(): ?string
    {
        return $this->searchByAlias;
    }

    /**
     * @param string|null $searchByAlias
     * @return BrandCriteriaInterface
     */
    public function setSearchByAlias(?string $searchByAlias):BrandCriteriaInterface
    {
        $this->searchByAlias = $searchByAlias;
        return $this;
    }

}