<?php

namespace Shop\Models\Shop\Base;

use \Exception;
use \PDO;
use Diamond\Models\Domain\Domain;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Address\Address;
use Shop\Models\Customer\Customer;
use Shop\Models\Manager\Manager;
use Shop\Models\Shop\Shop as ChildShop;
use Shop\Models\Shop\ShopQuery as ChildShopQuery;
use Shop\Models\Shop\ShopShopsArchive as ChildShopShopsArchive;
use Shop\Models\Shop\Map\ShopTableMap;

/**
 * Base class that represents a query for the 'shop_shops' table.
 *
 *
 *
 * @method     ChildShopQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildShopQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildShopQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildShopQuery orderByImage($order = Criteria::ASC) Order by the image column
 * @method     ChildShopQuery orderByLogo($order = Criteria::ASC) Order by the logo column
 * @method     ChildShopQuery orderByWorkTime($order = Criteria::ASC) Order by the work_time column
 * @method     ChildShopQuery orderBydirectorContact($order = Criteria::ASC) Order by the director_contact column
 * @method     ChildShopQuery orderByPhones($order = Criteria::ASC) Order by the phones column
 * @method     ChildShopQuery orderByemails($order = Criteria::ASC) Order by the emails column
 * @method     ChildShopQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method     ChildShopQuery orderByParentId($order = Criteria::ASC) Order by the parent_id column
 * @method     ChildShopQuery orderByDomainId($order = Criteria::ASC) Order by the domain_id column
 * @method     ChildShopQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildShopQuery orderByContractorId($order = Criteria::ASC) Order by the contractor_id column
 *
 * @method     ChildShopQuery groupById() Group by the id column
 * @method     ChildShopQuery groupByTitle() Group by the title column
 * @method     ChildShopQuery groupByDesc() Group by the desc column
 * @method     ChildShopQuery groupByImage() Group by the image column
 * @method     ChildShopQuery groupByLogo() Group by the logo column
 * @method     ChildShopQuery groupByWorkTime() Group by the work_time column
 * @method     ChildShopQuery groupBydirectorContact() Group by the director_contact column
 * @method     ChildShopQuery groupByPhones() Group by the phones column
 * @method     ChildShopQuery groupByemails() Group by the emails column
 * @method     ChildShopQuery groupByType() Group by the type column
 * @method     ChildShopQuery groupByParentId() Group by the parent_id column
 * @method     ChildShopQuery groupByDomainId() Group by the domain_id column
 * @method     ChildShopQuery groupByActive() Group by the active column
 * @method     ChildShopQuery groupByContractorId() Group by the contractor_id column
 *
 * @method     ChildShopQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopQuery leftJoinParentShop($relationAlias = null) Adds a LEFT JOIN clause to the query using the ParentShop relation
 * @method     ChildShopQuery rightJoinParentShop($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ParentShop relation
 * @method     ChildShopQuery innerJoinParentShop($relationAlias = null) Adds a INNER JOIN clause to the query using the ParentShop relation
 *
 * @method     ChildShopQuery joinWithParentShop($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ParentShop relation
 *
 * @method     ChildShopQuery leftJoinWithParentShop() Adds a LEFT JOIN clause and with to the query using the ParentShop relation
 * @method     ChildShopQuery rightJoinWithParentShop() Adds a RIGHT JOIN clause and with to the query using the ParentShop relation
 * @method     ChildShopQuery innerJoinWithParentShop() Adds a INNER JOIN clause and with to the query using the ParentShop relation
 *
 * @method     ChildShopQuery leftJoinDomain($relationAlias = null) Adds a LEFT JOIN clause to the query using the Domain relation
 * @method     ChildShopQuery rightJoinDomain($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Domain relation
 * @method     ChildShopQuery innerJoinDomain($relationAlias = null) Adds a INNER JOIN clause to the query using the Domain relation
 *
 * @method     ChildShopQuery joinWithDomain($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Domain relation
 *
 * @method     ChildShopQuery leftJoinWithDomain() Adds a LEFT JOIN clause and with to the query using the Domain relation
 * @method     ChildShopQuery rightJoinWithDomain() Adds a RIGHT JOIN clause and with to the query using the Domain relation
 * @method     ChildShopQuery innerJoinWithDomain() Adds a INNER JOIN clause and with to the query using the Domain relation
 *
 * @method     ChildShopQuery leftJoinContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Contractor relation
 * @method     ChildShopQuery rightJoinContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Contractor relation
 * @method     ChildShopQuery innerJoinContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the Contractor relation
 *
 * @method     ChildShopQuery joinWithContractor($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Contractor relation
 *
 * @method     ChildShopQuery leftJoinWithContractor() Adds a LEFT JOIN clause and with to the query using the Contractor relation
 * @method     ChildShopQuery rightJoinWithContractor() Adds a RIGHT JOIN clause and with to the query using the Contractor relation
 * @method     ChildShopQuery innerJoinWithContractor() Adds a INNER JOIN clause and with to the query using the Contractor relation
 *
 * @method     ChildShopQuery leftJoinShopRelatedById($relationAlias = null) Adds a LEFT JOIN clause to the query using the ShopRelatedById relation
 * @method     ChildShopQuery rightJoinShopRelatedById($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ShopRelatedById relation
 * @method     ChildShopQuery innerJoinShopRelatedById($relationAlias = null) Adds a INNER JOIN clause to the query using the ShopRelatedById relation
 *
 * @method     ChildShopQuery joinWithShopRelatedById($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ShopRelatedById relation
 *
 * @method     ChildShopQuery leftJoinWithShopRelatedById() Adds a LEFT JOIN clause and with to the query using the ShopRelatedById relation
 * @method     ChildShopQuery rightJoinWithShopRelatedById() Adds a RIGHT JOIN clause and with to the query using the ShopRelatedById relation
 * @method     ChildShopQuery innerJoinWithShopRelatedById() Adds a INNER JOIN clause and with to the query using the ShopRelatedById relation
 *
 * @method     ChildShopQuery leftJoinManager($relationAlias = null) Adds a LEFT JOIN clause to the query using the Manager relation
 * @method     ChildShopQuery rightJoinManager($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Manager relation
 * @method     ChildShopQuery innerJoinManager($relationAlias = null) Adds a INNER JOIN clause to the query using the Manager relation
 *
 * @method     ChildShopQuery joinWithManager($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Manager relation
 *
 * @method     ChildShopQuery leftJoinWithManager() Adds a LEFT JOIN clause and with to the query using the Manager relation
 * @method     ChildShopQuery rightJoinWithManager() Adds a RIGHT JOIN clause and with to the query using the Manager relation
 * @method     ChildShopQuery innerJoinWithManager() Adds a INNER JOIN clause and with to the query using the Manager relation
 *
 * @method     ChildShopQuery leftJoinAddress($relationAlias = null) Adds a LEFT JOIN clause to the query using the Address relation
 * @method     ChildShopQuery rightJoinAddress($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Address relation
 * @method     ChildShopQuery innerJoinAddress($relationAlias = null) Adds a INNER JOIN clause to the query using the Address relation
 *
 * @method     ChildShopQuery joinWithAddress($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Address relation
 *
 * @method     ChildShopQuery leftJoinWithAddress() Adds a LEFT JOIN clause and with to the query using the Address relation
 * @method     ChildShopQuery rightJoinWithAddress() Adds a RIGHT JOIN clause and with to the query using the Address relation
 * @method     ChildShopQuery innerJoinWithAddress() Adds a INNER JOIN clause and with to the query using the Address relation
 *
 * @method     \Shop\Models\Shop\ShopQuery|\Diamond\Models\Domain\DomainQuery|\Shop\Models\Customer\CustomerQuery|\Shop\Models\Manager\ManagerQuery|\Shop\Models\Address\AddressQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildShop findOne(ConnectionInterface $con = null) Return the first ChildShop matching the query
 * @method     ChildShop findOneOrCreate(ConnectionInterface $con = null) Return the first ChildShop matching the query, or a new ChildShop object populated from the query conditions when no match is found
 *
 * @method     ChildShop findOneById(int $id) Return the first ChildShop filtered by the id column
 * @method     ChildShop findOneByTitle(string $title) Return the first ChildShop filtered by the title column
 * @method     ChildShop findOneByDesc(string $desc) Return the first ChildShop filtered by the desc column
 * @method     ChildShop findOneByImage(string $image) Return the first ChildShop filtered by the image column
 * @method     ChildShop findOneByLogo(string $logo) Return the first ChildShop filtered by the logo column
 * @method     ChildShop findOneByWorkTime(string $work_time) Return the first ChildShop filtered by the work_time column
 * @method     ChildShop findOneBydirectorContact(string $director_contact) Return the first ChildShop filtered by the director_contact column
 * @method     ChildShop findOneByPhones(string $phones) Return the first ChildShop filtered by the phones column
 * @method     ChildShop findOneByemails(string $emails) Return the first ChildShop filtered by the emails column
 * @method     ChildShop findOneByType(string $type) Return the first ChildShop filtered by the type column
 * @method     ChildShop findOneByParentId(int $parent_id) Return the first ChildShop filtered by the parent_id column
 * @method     ChildShop findOneByDomainId(int $domain_id) Return the first ChildShop filtered by the domain_id column
 * @method     ChildShop findOneByActive(string $active) Return the first ChildShop filtered by the active column
 * @method     ChildShop findOneByContractorId(int $contractor_id) Return the first ChildShop filtered by the contractor_id column *

 * @method     ChildShop requirePk($key, ConnectionInterface $con = null) Return the ChildShop by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOne(ConnectionInterface $con = null) Return the first ChildShop matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShop requireOneById(int $id) Return the first ChildShop filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByTitle(string $title) Return the first ChildShop filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByDesc(string $desc) Return the first ChildShop filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByImage(string $image) Return the first ChildShop filtered by the image column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByLogo(string $logo) Return the first ChildShop filtered by the logo column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByWorkTime(string $work_time) Return the first ChildShop filtered by the work_time column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneBydirectorContact(string $director_contact) Return the first ChildShop filtered by the director_contact column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByPhones(string $phones) Return the first ChildShop filtered by the phones column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByemails(string $emails) Return the first ChildShop filtered by the emails column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByType(string $type) Return the first ChildShop filtered by the type column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByParentId(int $parent_id) Return the first ChildShop filtered by the parent_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByDomainId(int $domain_id) Return the first ChildShop filtered by the domain_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByActive(string $active) Return the first ChildShop filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShop requireOneByContractorId(int $contractor_id) Return the first ChildShop filtered by the contractor_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShop[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildShop objects based on current ModelCriteria
 * @method     ChildShop[]|ObjectCollection findById(int $id) Return ChildShop objects filtered by the id column
 * @method     ChildShop[]|ObjectCollection findByTitle(string $title) Return ChildShop objects filtered by the title column
 * @method     ChildShop[]|ObjectCollection findByDesc(string $desc) Return ChildShop objects filtered by the desc column
 * @method     ChildShop[]|ObjectCollection findByImage(string $image) Return ChildShop objects filtered by the image column
 * @method     ChildShop[]|ObjectCollection findByLogo(string $logo) Return ChildShop objects filtered by the logo column
 * @method     ChildShop[]|ObjectCollection findByWorkTime(string $work_time) Return ChildShop objects filtered by the work_time column
 * @method     ChildShop[]|ObjectCollection findBydirectorContact(string $director_contact) Return ChildShop objects filtered by the director_contact column
 * @method     ChildShop[]|ObjectCollection findByPhones(string $phones) Return ChildShop objects filtered by the phones column
 * @method     ChildShop[]|ObjectCollection findByemails(string $emails) Return ChildShop objects filtered by the emails column
 * @method     ChildShop[]|ObjectCollection findByType(string $type) Return ChildShop objects filtered by the type column
 * @method     ChildShop[]|ObjectCollection findByParentId(int $parent_id) Return ChildShop objects filtered by the parent_id column
 * @method     ChildShop[]|ObjectCollection findByDomainId(int $domain_id) Return ChildShop objects filtered by the domain_id column
 * @method     ChildShop[]|ObjectCollection findByActive(string $active) Return ChildShop objects filtered by the active column
 * @method     ChildShop[]|ObjectCollection findByContractorId(int $contractor_id) Return ChildShop objects filtered by the contractor_id column
 * @method     ChildShop[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;

    // delegate behavior

    protected $delegatedFields = [
        'PostCode' => 'Address',
        'Street' => 'Address',
        'House' => 'Address',
        'Room' => 'Address',
        'CityId' => 'Address',
        'MapLng' => 'Address',
        'MapLat' => 'Address',
    ];

protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Shop\Base\ShopQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Shop\\Shop', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildShopQuery) {
            return $criteria;
        }
        $query = new ChildShopQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShop|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShop A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `desc`, `image`, `logo`, `work_time`, `director_contact`, `phones`, `emails`, `type`, `parent_id`, `domain_id`, `active`, `contractor_id` FROM `shop_shops` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShop $obj */
            $obj = new ChildShop();
            $obj->hydrate($row);
            ShopTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildShop|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ShopTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ShopTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ShopTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ShopTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query on the image column
     *
     * Example usage:
     * <code>
     * $query->filterByImage('fooValue');   // WHERE image = 'fooValue'
     * $query->filterByImage('%fooValue%', Criteria::LIKE); // WHERE image LIKE '%fooValue%'
     * </code>
     *
     * @param     string $image The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByImage($image = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($image)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_IMAGE, $image, $comparison);
    }

    /**
     * Filter the query on the logo column
     *
     * Example usage:
     * <code>
     * $query->filterByLogo('fooValue');   // WHERE logo = 'fooValue'
     * $query->filterByLogo('%fooValue%', Criteria::LIKE); // WHERE logo LIKE '%fooValue%'
     * </code>
     *
     * @param     string $logo The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByLogo($logo = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($logo)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_LOGO, $logo, $comparison);
    }

    /**
     * Filter the query on the work_time column
     *
     * Example usage:
     * <code>
     * $query->filterByWorkTime('fooValue');   // WHERE work_time = 'fooValue'
     * $query->filterByWorkTime('%fooValue%', Criteria::LIKE); // WHERE work_time LIKE '%fooValue%'
     * </code>
     *
     * @param     string $workTime The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByWorkTime($workTime = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($workTime)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_WORK_TIME, $workTime, $comparison);
    }

    /**
     * Filter the query on the director_contact column
     *
     * Example usage:
     * <code>
     * $query->filterBydirectorContact('fooValue');   // WHERE director_contact = 'fooValue'
     * $query->filterBydirectorContact('%fooValue%', Criteria::LIKE); // WHERE director_contact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $directorContact The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterBydirectorContact($directorContact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($directorContact)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_DIRECTOR_CONTACT, $directorContact, $comparison);
    }

    /**
     * Filter the query on the phones column
     *
     * Example usage:
     * <code>
     * $query->filterByPhones('fooValue');   // WHERE phones = 'fooValue'
     * $query->filterByPhones('%fooValue%', Criteria::LIKE); // WHERE phones LIKE '%fooValue%'
     * </code>
     *
     * @param     string $phones The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByPhones($phones = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($phones)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_PHONES, $phones, $comparison);
    }

    /**
     * Filter the query on the emails column
     *
     * Example usage:
     * <code>
     * $query->filterByemails('fooValue');   // WHERE emails = 'fooValue'
     * $query->filterByemails('%fooValue%', Criteria::LIKE); // WHERE emails LIKE '%fooValue%'
     * </code>
     *
     * @param     string $emails The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByemails($emails = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($emails)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_EMAILS, $emails, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType('fooValue');   // WHERE type = 'fooValue'
     * $query->filterByType('%fooValue%', Criteria::LIKE); // WHERE type LIKE '%fooValue%'
     * </code>
     *
     * @param     string $type The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($type)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the parent_id column
     *
     * Example usage:
     * <code>
     * $query->filterByParentId(1234); // WHERE parent_id = 1234
     * $query->filterByParentId(array(12, 34)); // WHERE parent_id IN (12, 34)
     * $query->filterByParentId(array('min' => 12)); // WHERE parent_id > 12
     * </code>
     *
     * @see       filterByParentShop()
     *
     * @param     mixed $parentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByParentId($parentId = null, $comparison = null)
    {
        if (is_array($parentId)) {
            $useMinMax = false;
            if (isset($parentId['min'])) {
                $this->addUsingAlias(ShopTableMap::COL_PARENT_ID, $parentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($parentId['max'])) {
                $this->addUsingAlias(ShopTableMap::COL_PARENT_ID, $parentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_PARENT_ID, $parentId, $comparison);
    }

    /**
     * Filter the query on the domain_id column
     *
     * Example usage:
     * <code>
     * $query->filterByDomainId(1234); // WHERE domain_id = 1234
     * $query->filterByDomainId(array(12, 34)); // WHERE domain_id IN (12, 34)
     * $query->filterByDomainId(array('min' => 12)); // WHERE domain_id > 12
     * </code>
     *
     * @see       filterByDomain()
     *
     * @param     mixed $domainId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByDomainId($domainId = null, $comparison = null)
    {
        if (is_array($domainId)) {
            $useMinMax = false;
            if (isset($domainId['min'])) {
                $this->addUsingAlias(ShopTableMap::COL_DOMAIN_ID, $domainId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($domainId['max'])) {
                $this->addUsingAlias(ShopTableMap::COL_DOMAIN_ID, $domainId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_DOMAIN_ID, $domainId, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the contractor_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorId(1234); // WHERE contractor_id = 1234
     * $query->filterByContractorId(array(12, 34)); // WHERE contractor_id IN (12, 34)
     * $query->filterByContractorId(array('min' => 12)); // WHERE contractor_id > 12
     * </code>
     *
     * @see       filterByContractor()
     *
     * @param     mixed $contractorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function filterByContractorId($contractorId = null, $comparison = null)
    {
        if (is_array($contractorId)) {
            $useMinMax = false;
            if (isset($contractorId['min'])) {
                $this->addUsingAlias(ShopTableMap::COL_CONTRACTOR_ID, $contractorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorId['max'])) {
                $this->addUsingAlias(ShopTableMap::COL_CONTRACTOR_ID, $contractorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopTableMap::COL_CONTRACTOR_ID, $contractorId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Shop\Shop object
     *
     * @param \Shop\Models\Shop\Shop|ObjectCollection $shop The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopQuery The current query, for fluid interface
     */
    public function filterByParentShop($shop, $comparison = null)
    {
        if ($shop instanceof \Shop\Models\Shop\Shop) {
            return $this
                ->addUsingAlias(ShopTableMap::COL_PARENT_ID, $shop->getId(), $comparison);
        } elseif ($shop instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ShopTableMap::COL_PARENT_ID, $shop->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByParentShop() only accepts arguments of type \Shop\Models\Shop\Shop or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ParentShop relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function joinParentShop($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ParentShop');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ParentShop');
        }

        return $this;
    }

    /**
     * Use the ParentShop relation Shop object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Shop\ShopQuery A secondary query class using the current class as primary query
     */
    public function useParentShopQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinParentShop($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ParentShop', '\Shop\Models\Shop\ShopQuery');
    }

    /**
     * Filter the query by a related \Diamond\Models\Domain\Domain object
     *
     * @param \Diamond\Models\Domain\Domain|ObjectCollection $domain The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopQuery The current query, for fluid interface
     */
    public function filterByDomain($domain, $comparison = null)
    {
        if ($domain instanceof \Diamond\Models\Domain\Domain) {
            return $this
                ->addUsingAlias(ShopTableMap::COL_DOMAIN_ID, $domain->getId(), $comparison);
        } elseif ($domain instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ShopTableMap::COL_DOMAIN_ID, $domain->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByDomain() only accepts arguments of type \Diamond\Models\Domain\Domain or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Domain relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function joinDomain($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Domain');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Domain');
        }

        return $this;
    }

    /**
     * Use the Domain relation Domain object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Domain\DomainQuery A secondary query class using the current class as primary query
     */
    public function useDomainQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinDomain($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Domain', '\Diamond\Models\Domain\DomainQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Customer\Customer object
     *
     * @param \Shop\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopQuery The current query, for fluid interface
     */
    public function filterByContractor($customer, $comparison = null)
    {
        if ($customer instanceof \Shop\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(ShopTableMap::COL_CONTRACTOR_ID, $customer->getId(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ShopTableMap::COL_CONTRACTOR_ID, $customer->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByContractor() only accepts arguments of type \Shop\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Contractor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function joinContractor($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Contractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Contractor');
        }

        return $this;
    }

    /**
     * Use the Contractor relation Customer object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useContractorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Contractor', '\Shop\Models\Customer\CustomerQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Shop\Shop object
     *
     * @param \Shop\Models\Shop\Shop|ObjectCollection $shop the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildShopQuery The current query, for fluid interface
     */
    public function filterByShopRelatedById($shop, $comparison = null)
    {
        if ($shop instanceof \Shop\Models\Shop\Shop) {
            return $this
                ->addUsingAlias(ShopTableMap::COL_ID, $shop->getParentId(), $comparison);
        } elseif ($shop instanceof ObjectCollection) {
            return $this
                ->useShopRelatedByIdQuery()
                ->filterByPrimaryKeys($shop->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByShopRelatedById() only accepts arguments of type \Shop\Models\Shop\Shop or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ShopRelatedById relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function joinShopRelatedById($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ShopRelatedById');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ShopRelatedById');
        }

        return $this;
    }

    /**
     * Use the ShopRelatedById relation Shop object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Shop\ShopQuery A secondary query class using the current class as primary query
     */
    public function useShopRelatedByIdQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinShopRelatedById($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ShopRelatedById', '\Shop\Models\Shop\ShopQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Manager\Manager object
     *
     * @param \Shop\Models\Manager\Manager|ObjectCollection $manager the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildShopQuery The current query, for fluid interface
     */
    public function filterByManager($manager, $comparison = null)
    {
        if ($manager instanceof \Shop\Models\Manager\Manager) {
            return $this
                ->addUsingAlias(ShopTableMap::COL_ID, $manager->getShopId(), $comparison);
        } elseif ($manager instanceof ObjectCollection) {
            return $this
                ->useManagerQuery()
                ->filterByPrimaryKeys($manager->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByManager() only accepts arguments of type \Shop\Models\Manager\Manager or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Manager relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function joinManager($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Manager');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Manager');
        }

        return $this;
    }

    /**
     * Use the Manager relation Manager object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Manager\ManagerQuery A secondary query class using the current class as primary query
     */
    public function useManagerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinManager($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Manager', '\Shop\Models\Manager\ManagerQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Address\Address object
     *
     * @param \Shop\Models\Address\Address|ObjectCollection $address the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildShopQuery The current query, for fluid interface
     */
    public function filterByAddress($address, $comparison = null)
    {
        if ($address instanceof \Shop\Models\Address\Address) {
            return $this
                ->addUsingAlias(ShopTableMap::COL_ID, $address->getId(), $comparison);
        } elseif ($address instanceof ObjectCollection) {
            return $this
                ->useAddressQuery()
                ->filterByPrimaryKeys($address->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByAddress() only accepts arguments of type \Shop\Models\Address\Address or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Address relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function joinAddress($relationAlias = null, $joinType = 'LEFT JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Address');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Address');
        }

        return $this;
    }

    /**
     * Use the Address relation Address object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Address\AddressQuery A secondary query class using the current class as primary query
     */
    public function useAddressQuery($relationAlias = null, $joinType = 'LEFT JOIN')
    {
        return $this
            ->joinAddress($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Address', '\Shop\Models\Address\AddressQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildShop $shop Object to remove from the list of results
     *
     * @return $this|ChildShopQuery The current query, for fluid interface
     */
    public function prune($shop = null)
    {
        if ($shop) {
            $this->addUsingAlias(ShopTableMap::COL_ID, $shop->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePreDelete(ConnectionInterface $con)
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the shop_shops table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopTableMap::clearInstancePool();
            ShopTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildShopShopsArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param      ConnectionInterface $con    Connection to use.
     * @param      Boolean $useLittleMemory    Whether or not to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return     int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param boolean True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete($archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

    // delegate behavior
    /**
    * Filter the query by post_code column
    *
    * Example usage:
    * <code>
        * $query->filterByPostCode(1234); // WHERE post_code = 1234
        * $query->filterByPostCode(array(12, 34)); // WHERE post_code IN (12, 34)
        * $query->filterByPostCode(array('min' => 12)); // WHERE post_code >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildShopQuery The current query, for fluid interface
    */
    public function filterByPostCode($value = null, $comparison = null)
    {
        return $this->useAddressQuery()->filterByPostCode($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByPostCode($order = Criteria::ASC)
    {
        return $this->useAddressQuery()->orderByPostCode($order)->endUse();
    }
    /**
    * Filter the query by street column
    *
    * Example usage:
    * <code>
        * $query->filterByStreet(1234); // WHERE street = 1234
        * $query->filterByStreet(array(12, 34)); // WHERE street IN (12, 34)
        * $query->filterByStreet(array('min' => 12)); // WHERE street >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildShopQuery The current query, for fluid interface
    */
    public function filterByStreet($value = null, $comparison = null)
    {
        return $this->useAddressQuery()->filterByStreet($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByStreet($order = Criteria::ASC)
    {
        return $this->useAddressQuery()->orderByStreet($order)->endUse();
    }
    /**
    * Filter the query by house column
    *
    * Example usage:
    * <code>
        * $query->filterByHouse(1234); // WHERE house = 1234
        * $query->filterByHouse(array(12, 34)); // WHERE house IN (12, 34)
        * $query->filterByHouse(array('min' => 12)); // WHERE house >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildShopQuery The current query, for fluid interface
    */
    public function filterByHouse($value = null, $comparison = null)
    {
        return $this->useAddressQuery()->filterByHouse($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByHouse($order = Criteria::ASC)
    {
        return $this->useAddressQuery()->orderByHouse($order)->endUse();
    }
    /**
    * Filter the query by room column
    *
    * Example usage:
    * <code>
        * $query->filterByRoom(1234); // WHERE room = 1234
        * $query->filterByRoom(array(12, 34)); // WHERE room IN (12, 34)
        * $query->filterByRoom(array('min' => 12)); // WHERE room >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildShopQuery The current query, for fluid interface
    */
    public function filterByRoom($value = null, $comparison = null)
    {
        return $this->useAddressQuery()->filterByRoom($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByRoom($order = Criteria::ASC)
    {
        return $this->useAddressQuery()->orderByRoom($order)->endUse();
    }
    /**
    * Filter the query by city_id column
    *
    * Example usage:
    * <code>
        * $query->filterByCityId(1234); // WHERE city_id = 1234
        * $query->filterByCityId(array(12, 34)); // WHERE city_id IN (12, 34)
        * $query->filterByCityId(array('min' => 12)); // WHERE city_id >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildShopQuery The current query, for fluid interface
    */
    public function filterByCityId($value = null, $comparison = null)
    {
        return $this->useAddressQuery()->filterByCityId($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByCityId($order = Criteria::ASC)
    {
        return $this->useAddressQuery()->orderByCityId($order)->endUse();
    }
    /**
    * Filter the query by mapLng column
    *
    * Example usage:
    * <code>
        * $query->filterByMapLng(1234); // WHERE mapLng = 1234
        * $query->filterByMapLng(array(12, 34)); // WHERE mapLng IN (12, 34)
        * $query->filterByMapLng(array('min' => 12)); // WHERE mapLng >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildShopQuery The current query, for fluid interface
    */
    public function filterByMapLng($value = null, $comparison = null)
    {
        return $this->useAddressQuery()->filterByMapLng($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByMapLng($order = Criteria::ASC)
    {
        return $this->useAddressQuery()->orderByMapLng($order)->endUse();
    }
    /**
    * Filter the query by mapLat column
    *
    * Example usage:
    * <code>
        * $query->filterByMapLat(1234); // WHERE mapLat = 1234
        * $query->filterByMapLat(array(12, 34)); // WHERE mapLat IN (12, 34)
        * $query->filterByMapLat(array('min' => 12)); // WHERE mapLat >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildShopQuery The current query, for fluid interface
    */
    public function filterByMapLat($value = null, $comparison = null)
    {
        return $this->useAddressQuery()->filterByMapLat($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByMapLat($order = Criteria::ASC)
    {
        return $this->useAddressQuery()->orderByMapLat($order)->endUse();
    }

    /**
     * Adds a condition on a column based on a column phpName and a value
     * Uses introspection to translate the column phpName into a fully qualified name
     * Warning: recognizes only the phpNames of the main Model (not joined tables)
     * <code>
     * $c->filterBy('Title', 'foo');
     * </code>
     *
     * @see Criteria::add()
     *
     * @param string $column     A string representing thecolumn phpName, e.g. 'AuthorId'
     * @param mixed  $value      A value for the condition
     * @param string $comparison What to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ModelCriteria The current object, for fluid interface
     */
    public function filterBy($column, $value, $comparison = Criteria::EQUAL)
    {
        if (isset($this->delegatedFields[$column])) {
            $methodUse = "use{$this->delegatedFields[$column]}Query";

            return $this->{$methodUse}()->filterBy($column, $value, $comparison)->endUse();
        } else {
            return $this->add($this->getRealColumnName($column), $value, $comparison);
        }
    }

} // ShopQuery
